// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> and their operations.
    /// Each <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/> in the collection will belong to the same instance of <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection"/> instance call the GetSynapseSqlPoolVulnerabilityAssessmentRuleBaselines method from an instance of <see cref="SynapseSqlPoolVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection : ArmCollection
    {
        private readonly ClientDiagnostics _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics;
        private readonly SqlPoolVulnerabilityAssessmentRuleBaselinesRestOperations _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection"/> class for mocking. </summary>
        protected SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource.ResourceType, out string synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesApiVersion);
            _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient = new SqlPoolVulnerabilityAssessmentRuleBaselinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SynapseSqlPoolVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SynapseSqlPoolVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a Sql pool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data, cancellationToken).ConfigureAwait(false);
                var uri = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a Sql pool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> CreateOrUpdate(WaitUntil waitUntil, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data, cancellationToken);
                var uri = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a SqlPool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>> GetAsync(string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a SqlPool's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> Get(string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual Response<bool> Exists(string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<NullableResponse<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>> GetIfExistsAsync(string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual NullableResponse<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource> GetIfExists(string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SynapseSqlPoolVulnerabilityAssessmentRuleBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolVulnerabilityAssessmentRuleBaselineSqlPoolVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
