// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapseSqlPoolColumnResource"/> and their operations.
    /// Each <see cref="SynapseSqlPoolColumnResource"/> in the collection will belong to the same instance of <see cref="SynapseSqlPoolTableResource"/>.
    /// To get a <see cref="SynapseSqlPoolColumnCollection"/> instance call the GetSynapseSqlPoolColumns method from an instance of <see cref="SynapseSqlPoolTableResource"/>.
    /// </summary>
    public partial class SynapseSqlPoolColumnCollection : ArmCollection, IEnumerable<SynapseSqlPoolColumnResource>, IAsyncEnumerable<SynapseSqlPoolColumnResource>
    {
        private readonly ClientDiagnostics _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics;
        private readonly SqlPoolColumnsRestOperations _synapseSqlPoolColumnSqlPoolColumnsRestClient;
        private readonly ClientDiagnostics _synapseSqlPoolColumnSqlPoolTableColumnsClientDiagnostics;
        private readonly SqlPoolTableColumnsRestOperations _synapseSqlPoolColumnSqlPoolTableColumnsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapseSqlPoolColumnCollection"/> class for mocking. </summary>
        protected SynapseSqlPoolColumnCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseSqlPoolColumnCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapseSqlPoolColumnCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseSqlPoolColumnResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseSqlPoolColumnResource.ResourceType, out string synapseSqlPoolColumnSqlPoolColumnsApiVersion);
            _synapseSqlPoolColumnSqlPoolColumnsRestClient = new SqlPoolColumnsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseSqlPoolColumnSqlPoolColumnsApiVersion);
            _synapseSqlPoolColumnSqlPoolTableColumnsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseSqlPoolColumnResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseSqlPoolColumnResource.ResourceType, out string synapseSqlPoolColumnSqlPoolTableColumnsApiVersion);
            _synapseSqlPoolColumnSqlPoolTableColumnsRestClient = new SqlPoolTableColumnsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseSqlPoolColumnSqlPoolTableColumnsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SynapseSqlPoolTableResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SynapseSqlPoolTableResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get Sql pool column
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolColumns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="columnName"> The name of the column. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="columnName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="columnName"/> is null. </exception>
        public virtual async Task<Response<SynapseSqlPoolColumnResource>> GetAsync(string columnName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(columnName, nameof(columnName));

            using var scope = _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics.CreateScope("SynapseSqlPoolColumnCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolColumnSqlPoolColumnsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, columnName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolColumnResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get Sql pool column
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolColumns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="columnName"> The name of the column. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="columnName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="columnName"/> is null. </exception>
        public virtual Response<SynapseSqlPoolColumnResource> Get(string columnName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(columnName, nameof(columnName));

            using var scope = _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics.CreateScope("SynapseSqlPoolColumnCollection.Get");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolColumnSqlPoolColumnsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, columnName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolColumnResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets columns in a given table in a SQL pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolTableColumns_ListByTableName</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> An OData filter expression that filters elements in the collection. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapseSqlPoolColumnResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapseSqlPoolColumnResource> GetAllAsync(string filter = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseSqlPoolColumnSqlPoolTableColumnsRestClient.CreateListByTableNameRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseSqlPoolColumnSqlPoolTableColumnsRestClient.CreateListByTableNameNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapseSqlPoolColumnResource(Client, SynapseSqlPoolColumnData.DeserializeSynapseSqlPoolColumnData(e)), _synapseSqlPoolColumnSqlPoolTableColumnsClientDiagnostics, Pipeline, "SynapseSqlPoolColumnCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets columns in a given table in a SQL pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolTableColumns_ListByTableName</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> An OData filter expression that filters elements in the collection. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapseSqlPoolColumnResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapseSqlPoolColumnResource> GetAll(string filter = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseSqlPoolColumnSqlPoolTableColumnsRestClient.CreateListByTableNameRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseSqlPoolColumnSqlPoolTableColumnsRestClient.CreateListByTableNameNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapseSqlPoolColumnResource(Client, SynapseSqlPoolColumnData.DeserializeSynapseSqlPoolColumnData(e)), _synapseSqlPoolColumnSqlPoolTableColumnsClientDiagnostics, Pipeline, "SynapseSqlPoolColumnCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolColumns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="columnName"> The name of the column. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="columnName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="columnName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string columnName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(columnName, nameof(columnName));

            using var scope = _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics.CreateScope("SynapseSqlPoolColumnCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolColumnSqlPoolColumnsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, columnName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolColumns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="columnName"> The name of the column. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="columnName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="columnName"/> is null. </exception>
        public virtual Response<bool> Exists(string columnName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(columnName, nameof(columnName));

            using var scope = _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics.CreateScope("SynapseSqlPoolColumnCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolColumnSqlPoolColumnsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, columnName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolColumns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="columnName"> The name of the column. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="columnName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="columnName"/> is null. </exception>
        public virtual async Task<NullableResponse<SynapseSqlPoolColumnResource>> GetIfExistsAsync(string columnName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(columnName, nameof(columnName));

            using var scope = _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics.CreateScope("SynapseSqlPoolColumnCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapseSqlPoolColumnSqlPoolColumnsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, columnName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapseSqlPoolColumnResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolColumnResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolColumns_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseSqlPoolColumnResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="columnName"> The name of the column. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="columnName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="columnName"/> is null. </exception>
        public virtual NullableResponse<SynapseSqlPoolColumnResource> GetIfExists(string columnName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(columnName, nameof(columnName));

            using var scope = _synapseSqlPoolColumnSqlPoolColumnsClientDiagnostics.CreateScope("SynapseSqlPoolColumnCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapseSqlPoolColumnSqlPoolColumnsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, columnName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapseSqlPoolColumnResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseSqlPoolColumnResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SynapseSqlPoolColumnResource> IEnumerable<SynapseSqlPoolColumnResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SynapseSqlPoolColumnResource> IAsyncEnumerable<SynapseSqlPoolColumnResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
