// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing the SynapseServerVulnerabilityAssessment data model.
    /// A server vulnerability assessment.
    /// </summary>
    public partial class SynapseServerVulnerabilityAssessmentData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseServerVulnerabilityAssessmentData"/>. </summary>
        public SynapseServerVulnerabilityAssessmentData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SynapseServerVulnerabilityAssessmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageContainerPath"> A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/). </param>
        /// <param name="storageContainerSasKey"> A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. </param>
        /// <param name="storageAccountAccessKey"> Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. </param>
        /// <param name="recurringScans"> The recurring scans settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseServerVulnerabilityAssessmentData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string storageContainerPath, string storageContainerSasKey, string storageAccountAccessKey, SynapseVulnerabilityAssessmentRecurringScansProperties recurringScans, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            StorageContainerPath = storageContainerPath;
            StorageContainerSasKey = storageContainerSasKey;
            StorageAccountAccessKey = storageAccountAccessKey;
            RecurringScans = recurringScans;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/). </summary>
        public string StorageContainerPath { get; set; }
        /// <summary> A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. </summary>
        public string StorageContainerSasKey { get; set; }
        /// <summary> Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. </summary>
        public string StorageAccountAccessKey { get; set; }
        /// <summary> The recurring scans settings. </summary>
        public SynapseVulnerabilityAssessmentRecurringScansProperties RecurringScans { get; set; }
    }
}
