// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    public partial class SynapseServerVulnerabilityAssessmentData : IUtf8JsonSerializable, IJsonModel<SynapseServerVulnerabilityAssessmentData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SynapseServerVulnerabilityAssessmentData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SynapseServerVulnerabilityAssessmentData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseServerVulnerabilityAssessmentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseServerVulnerabilityAssessmentData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(StorageContainerPath))
            {
                writer.WritePropertyName("storageContainerPath"u8);
                writer.WriteStringValue(StorageContainerPath);
            }
            if (Optional.IsDefined(StorageContainerSasKey))
            {
                writer.WritePropertyName("storageContainerSasKey"u8);
                writer.WriteStringValue(StorageContainerSasKey);
            }
            if (Optional.IsDefined(StorageAccountAccessKey))
            {
                writer.WritePropertyName("storageAccountAccessKey"u8);
                writer.WriteStringValue(StorageAccountAccessKey);
            }
            if (Optional.IsDefined(RecurringScans))
            {
                writer.WritePropertyName("recurringScans"u8);
                writer.WriteObjectValue(RecurringScans, options);
            }
            writer.WriteEndObject();
        }

        SynapseServerVulnerabilityAssessmentData IJsonModel<SynapseServerVulnerabilityAssessmentData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseServerVulnerabilityAssessmentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseServerVulnerabilityAssessmentData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSynapseServerVulnerabilityAssessmentData(document.RootElement, options);
        }

        internal static SynapseServerVulnerabilityAssessmentData DeserializeSynapseServerVulnerabilityAssessmentData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string storageContainerPath = default;
            string storageContainerSasKey = default;
            string storageAccountAccessKey = default;
            SynapseVulnerabilityAssessmentRecurringScansProperties recurringScans = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("storageContainerPath"u8))
                        {
                            storageContainerPath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("storageContainerSasKey"u8))
                        {
                            storageContainerSasKey = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("storageAccountAccessKey"u8))
                        {
                            storageAccountAccessKey = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("recurringScans"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            recurringScans = SynapseVulnerabilityAssessmentRecurringScansProperties.DeserializeSynapseVulnerabilityAssessmentRecurringScansProperties(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SynapseServerVulnerabilityAssessmentData(
                id,
                name,
                type,
                systemData,
                storageContainerPath,
                storageContainerSasKey,
                storageAccountAccessKey,
                recurringScans,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SynapseServerVulnerabilityAssessmentData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseServerVulnerabilityAssessmentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SynapseServerVulnerabilityAssessmentData)} does not support writing '{options.Format}' format.");
            }
        }

        SynapseServerVulnerabilityAssessmentData IPersistableModel<SynapseServerVulnerabilityAssessmentData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseServerVulnerabilityAssessmentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSynapseServerVulnerabilityAssessmentData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SynapseServerVulnerabilityAssessmentData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SynapseServerVulnerabilityAssessmentData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
