// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapseRecoverableSqlPoolResource"/> and their operations.
    /// Each <see cref="SynapseRecoverableSqlPoolResource"/> in the collection will belong to the same instance of <see cref="SynapseWorkspaceResource"/>.
    /// To get a <see cref="SynapseRecoverableSqlPoolCollection"/> instance call the GetSynapseRecoverableSqlPools method from an instance of <see cref="SynapseWorkspaceResource"/>.
    /// </summary>
    public partial class SynapseRecoverableSqlPoolCollection : ArmCollection, IEnumerable<SynapseRecoverableSqlPoolResource>, IAsyncEnumerable<SynapseRecoverableSqlPoolResource>
    {
        private readonly ClientDiagnostics _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics;
        private readonly WorkspaceManagedSqlServerRecoverableSqlPoolsRestOperations _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapseRecoverableSqlPoolCollection"/> class for mocking. </summary>
        protected SynapseRecoverableSqlPoolCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseRecoverableSqlPoolCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapseRecoverableSqlPoolCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseRecoverableSqlPoolResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseRecoverableSqlPoolResource.ResourceType, out string synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsApiVersion);
            _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient = new WorkspaceManagedSqlServerRecoverableSqlPoolsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SynapseWorkspaceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SynapseWorkspaceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get recoverable sql pools for workspace managed sql server.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools/{sqlPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sqlPoolName"> The name of the sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sqlPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sqlPoolName"/> is null. </exception>
        public virtual async Task<Response<SynapseRecoverableSqlPoolResource>> GetAsync(string sqlPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));

            using var scope = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics.CreateScope("SynapseRecoverableSqlPoolCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sqlPoolName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseRecoverableSqlPoolResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get recoverable sql pools for workspace managed sql server.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools/{sqlPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sqlPoolName"> The name of the sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sqlPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sqlPoolName"/> is null. </exception>
        public virtual Response<SynapseRecoverableSqlPoolResource> Get(string sqlPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));

            using var scope = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics.CreateScope("SynapseRecoverableSqlPoolCollection.Get");
            scope.Start();
            try
            {
                var response = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sqlPoolName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseRecoverableSqlPoolResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get list of recoverable sql pools for workspace managed sql server.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapseRecoverableSqlPoolResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapseRecoverableSqlPoolResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapseRecoverableSqlPoolResource(Client, SynapseRecoverableSqlPoolData.DeserializeSynapseRecoverableSqlPoolData(e)), _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics, Pipeline, "SynapseRecoverableSqlPoolCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get list of recoverable sql pools for workspace managed sql server.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapseRecoverableSqlPoolResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapseRecoverableSqlPoolResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapseRecoverableSqlPoolResource(Client, SynapseRecoverableSqlPoolData.DeserializeSynapseRecoverableSqlPoolData(e)), _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics, Pipeline, "SynapseRecoverableSqlPoolCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools/{sqlPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sqlPoolName"> The name of the sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sqlPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sqlPoolName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string sqlPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));

            using var scope = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics.CreateScope("SynapseRecoverableSqlPoolCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sqlPoolName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools/{sqlPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sqlPoolName"> The name of the sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sqlPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sqlPoolName"/> is null. </exception>
        public virtual Response<bool> Exists(string sqlPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));

            using var scope = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics.CreateScope("SynapseRecoverableSqlPoolCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sqlPoolName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools/{sqlPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sqlPoolName"> The name of the sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sqlPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sqlPoolName"/> is null. </exception>
        public virtual async Task<NullableResponse<SynapseRecoverableSqlPoolResource>> GetIfExistsAsync(string sqlPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));

            using var scope = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics.CreateScope("SynapseRecoverableSqlPoolCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sqlPoolName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapseRecoverableSqlPoolResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseRecoverableSqlPoolResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/recoverableSqlPools/{sqlPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerRecoverableSqlPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseRecoverableSqlPoolResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sqlPoolName"> The name of the sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="sqlPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="sqlPoolName"/> is null. </exception>
        public virtual NullableResponse<SynapseRecoverableSqlPoolResource> GetIfExists(string sqlPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));

            using var scope = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsClientDiagnostics.CreateScope("SynapseRecoverableSqlPoolCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapseRecoverableSqlPoolWorkspaceManagedSqlServerRecoverableSqlPoolsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, sqlPoolName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapseRecoverableSqlPoolResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseRecoverableSqlPoolResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SynapseRecoverableSqlPoolResource> IEnumerable<SynapseRecoverableSqlPoolResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SynapseRecoverableSqlPoolResource> IAsyncEnumerable<SynapseRecoverableSqlPoolResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
