// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapsePrivateLinkHubResource"/> and their operations.
    /// Each <see cref="SynapsePrivateLinkHubResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="SynapsePrivateLinkHubCollection"/> instance call the GetSynapsePrivateLinkHubs method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class SynapsePrivateLinkHubCollection : ArmCollection, IEnumerable<SynapsePrivateLinkHubResource>, IAsyncEnumerable<SynapsePrivateLinkHubResource>
    {
        private readonly ClientDiagnostics _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics;
        private readonly PrivateLinkHubsRestOperations _synapsePrivateLinkHubPrivateLinkHubsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapsePrivateLinkHubCollection"/> class for mocking. </summary>
        protected SynapsePrivateLinkHubCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapsePrivateLinkHubCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapsePrivateLinkHubCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapsePrivateLinkHubResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapsePrivateLinkHubResource.ResourceType, out string synapsePrivateLinkHubPrivateLinkHubsApiVersion);
            _synapsePrivateLinkHubPrivateLinkHubsRestClient = new PrivateLinkHubsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapsePrivateLinkHubPrivateLinkHubsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a privateLinkHub
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="data"> PrivateLinkHub create or update request properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SynapsePrivateLinkHubResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string privateLinkHubName, SynapsePrivateLinkHubData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, data, cancellationToken).ConfigureAwait(false);
                var uri = _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation<SynapsePrivateLinkHubResource>(Response.FromValue(new SynapsePrivateLinkHubResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a privateLinkHub
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="data"> PrivateLinkHub create or update request properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SynapsePrivateLinkHubResource> CreateOrUpdate(WaitUntil waitUntil, string privateLinkHubName, SynapsePrivateLinkHubData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, data, cancellationToken);
                var uri = _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SynapseArmOperation<SynapsePrivateLinkHubResource>(Response.FromValue(new SynapsePrivateLinkHubResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a privateLinkHub
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> is null. </exception>
        public virtual async Task<Response<SynapsePrivateLinkHubResource>> GetAsync(string privateLinkHubName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapsePrivateLinkHubPrivateLinkHubsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapsePrivateLinkHubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a privateLinkHub
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> is null. </exception>
        public virtual Response<SynapsePrivateLinkHubResource> Get(string privateLinkHubName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.Get");
            scope.Start();
            try
            {
                var response = _synapsePrivateLinkHubPrivateLinkHubsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapsePrivateLinkHubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a list of privateLinkHubs in a resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapsePrivateLinkHubResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapsePrivateLinkHubResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapsePrivateLinkHubResource(Client, SynapsePrivateLinkHubData.DeserializeSynapsePrivateLinkHubData(e)), _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics, Pipeline, "SynapsePrivateLinkHubCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns a list of privateLinkHubs in a resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapsePrivateLinkHubResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapsePrivateLinkHubResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapsePrivateLinkHubPrivateLinkHubsRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapsePrivateLinkHubResource(Client, SynapsePrivateLinkHubData.DeserializeSynapsePrivateLinkHubData(e)), _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics, Pipeline, "SynapsePrivateLinkHubCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string privateLinkHubName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapsePrivateLinkHubPrivateLinkHubsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> is null. </exception>
        public virtual Response<bool> Exists(string privateLinkHubName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapsePrivateLinkHubPrivateLinkHubsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> is null. </exception>
        public virtual async Task<NullableResponse<SynapsePrivateLinkHubResource>> GetIfExistsAsync(string privateLinkHubName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapsePrivateLinkHubPrivateLinkHubsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapsePrivateLinkHubResource>(response.GetRawResponse());
                return Response.FromValue(new SynapsePrivateLinkHubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/privateLinkHubs/{privateLinkHubName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateLinkHubs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapsePrivateLinkHubResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateLinkHubName"> Name of the privateLinkHub. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="privateLinkHubName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="privateLinkHubName"/> is null. </exception>
        public virtual NullableResponse<SynapsePrivateLinkHubResource> GetIfExists(string privateLinkHubName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(privateLinkHubName, nameof(privateLinkHubName));

            using var scope = _synapsePrivateLinkHubPrivateLinkHubsClientDiagnostics.CreateScope("SynapsePrivateLinkHubCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapsePrivateLinkHubPrivateLinkHubsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, privateLinkHubName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapsePrivateLinkHubResource>(response.GetRawResponse());
                return Response.FromValue(new SynapsePrivateLinkHubResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SynapsePrivateLinkHubResource> IEnumerable<SynapsePrivateLinkHubResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SynapsePrivateLinkHubResource> IAsyncEnumerable<SynapsePrivateLinkHubResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
