// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    public partial class SynapseMaintenanceWindowOptionData : IUtf8JsonSerializable, IJsonModel<SynapseMaintenanceWindowOptionData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SynapseMaintenanceWindowOptionData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SynapseMaintenanceWindowOptionData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseMaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseMaintenanceWindowOptionData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IsEnabled))
            {
                writer.WritePropertyName("isEnabled"u8);
                writer.WriteBooleanValue(IsEnabled.Value);
            }
            if (Optional.IsCollectionDefined(MaintenanceWindowCycles))
            {
                writer.WritePropertyName("maintenanceWindowCycles"u8);
                writer.WriteStartArray();
                foreach (var item in MaintenanceWindowCycles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(MinDurationInMinutes))
            {
                writer.WritePropertyName("minDurationInMinutes"u8);
                writer.WriteNumberValue(MinDurationInMinutes.Value);
            }
            if (Optional.IsDefined(DefaultDurationInMinutes))
            {
                writer.WritePropertyName("defaultDurationInMinutes"u8);
                writer.WriteNumberValue(DefaultDurationInMinutes.Value);
            }
            if (Optional.IsDefined(MinCycles))
            {
                writer.WritePropertyName("minCycles"u8);
                writer.WriteNumberValue(MinCycles.Value);
            }
            if (Optional.IsDefined(TimeGranularityInMinutes))
            {
                writer.WritePropertyName("timeGranularityInMinutes"u8);
                writer.WriteNumberValue(TimeGranularityInMinutes.Value);
            }
            if (Optional.IsDefined(AllowMultipleMaintenanceWindowsPerCycle))
            {
                writer.WritePropertyName("allowMultipleMaintenanceWindowsPerCycle"u8);
                writer.WriteBooleanValue(AllowMultipleMaintenanceWindowsPerCycle.Value);
            }
            writer.WriteEndObject();
        }

        SynapseMaintenanceWindowOptionData IJsonModel<SynapseMaintenanceWindowOptionData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseMaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseMaintenanceWindowOptionData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSynapseMaintenanceWindowOptionData(document.RootElement, options);
        }

        internal static SynapseMaintenanceWindowOptionData DeserializeSynapseMaintenanceWindowOptionData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            bool? isEnabled = default;
            IList<SynapseMaintenanceWindowTimeRange> maintenanceWindowCycles = default;
            int? minDurationInMinutes = default;
            int? defaultDurationInMinutes = default;
            int? minCycles = default;
            int? timeGranularityInMinutes = default;
            bool? allowMultipleMaintenanceWindowsPerCycle = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("isEnabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isEnabled = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("maintenanceWindowCycles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SynapseMaintenanceWindowTimeRange> array = new List<SynapseMaintenanceWindowTimeRange>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SynapseMaintenanceWindowTimeRange.DeserializeSynapseMaintenanceWindowTimeRange(item, options));
                            }
                            maintenanceWindowCycles = array;
                            continue;
                        }
                        if (property0.NameEquals("minDurationInMinutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minDurationInMinutes = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("defaultDurationInMinutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            defaultDurationInMinutes = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("minCycles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minCycles = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("timeGranularityInMinutes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            timeGranularityInMinutes = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("allowMultipleMaintenanceWindowsPerCycle"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allowMultipleMaintenanceWindowsPerCycle = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SynapseMaintenanceWindowOptionData(
                id,
                name,
                type,
                systemData,
                isEnabled,
                maintenanceWindowCycles ?? new ChangeTrackingList<SynapseMaintenanceWindowTimeRange>(),
                minDurationInMinutes,
                defaultDurationInMinutes,
                minCycles,
                timeGranularityInMinutes,
                allowMultipleMaintenanceWindowsPerCycle,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SynapseMaintenanceWindowOptionData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseMaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SynapseMaintenanceWindowOptionData)} does not support writing '{options.Format}' format.");
            }
        }

        SynapseMaintenanceWindowOptionData IPersistableModel<SynapseMaintenanceWindowOptionData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseMaintenanceWindowOptionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSynapseMaintenanceWindowOptionData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SynapseMaintenanceWindowOptionData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SynapseMaintenanceWindowOptionData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
