// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing the SynapseLibrary data model.
    /// Library response details
    /// </summary>
    public partial class SynapseLibraryData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseLibraryData"/>. </summary>
        public SynapseLibraryData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SynapseLibraryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="namePropertiesName"> Name of the library. </param>
        /// <param name="path"> Storage blob path of library. </param>
        /// <param name="containerName"> Storage blob container name. </param>
        /// <param name="uploadedOn"> The last update time of the library. </param>
        /// <param name="typePropertiesType"> Type of the library. </param>
        /// <param name="provisioningStatus"> Provisioning status of the library/package. </param>
        /// <param name="creatorId"> Creator Id of the library/package. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseLibraryData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string namePropertiesName, string path, string containerName, DateTimeOffset? uploadedOn, string typePropertiesType, string provisioningStatus, string creatorId, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            NamePropertiesName = namePropertiesName;
            Path = path;
            ContainerName = containerName;
            UploadedOn = uploadedOn;
            TypePropertiesType = typePropertiesType;
            ProvisioningStatus = provisioningStatus;
            CreatorId = creatorId;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the library. </summary>
        public string NamePropertiesName { get; set; }
        /// <summary> Storage blob path of library. </summary>
        public string Path { get; set; }
        /// <summary> Storage blob container name. </summary>
        public string ContainerName { get; set; }
        /// <summary> The last update time of the library. </summary>
        public DateTimeOffset? UploadedOn { get; set; }
        /// <summary> Type of the library. </summary>
        public string TypePropertiesType { get; set; }
        /// <summary> Provisioning status of the library/package. </summary>
        public string ProvisioningStatus { get; }
        /// <summary> Creator Id of the library/package. </summary>
        public string CreatorId { get; }
        /// <summary> Resource Etag. </summary>
        public ETag? ETag { get; }
    }
}
