// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing the SynapseGeoBackupPolicy data model.
    /// A database geo backup policy.
    /// </summary>
    public partial class SynapseGeoBackupPolicyData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseGeoBackupPolicyData"/>. </summary>
        /// <param name="state"> The state of the geo backup policy. </param>
        public SynapseGeoBackupPolicyData(SynapseGeoBackupPolicyState state)
        {
            State = state;
        }

        /// <summary> Initializes a new instance of <see cref="SynapseGeoBackupPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of geo backup policy.  This is metadata used for the Azure portal experience. </param>
        /// <param name="location"> Backup policy location. </param>
        /// <param name="state"> The state of the geo backup policy. </param>
        /// <param name="storageType"> The storage type of the geo backup policy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseGeoBackupPolicyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string kind, AzureLocation? location, SynapseGeoBackupPolicyState state, string storageType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Kind = kind;
            Location = location;
            State = state;
            StorageType = storageType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SynapseGeoBackupPolicyData"/> for deserialization. </summary>
        internal SynapseGeoBackupPolicyData()
        {
        }

        /// <summary> Kind of geo backup policy.  This is metadata used for the Azure portal experience. </summary>
        public string Kind { get; }
        /// <summary> Backup policy location. </summary>
        public AzureLocation? Location { get; }
        /// <summary> The state of the geo backup policy. </summary>
        public SynapseGeoBackupPolicyState State { get; set; }
        /// <summary> The storage type of the geo backup policy. </summary>
        public string StorageType { get; }
    }
}
