// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/> and their operations.
    /// Each <see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/> in the collection will belong to the same instance of <see cref="SynapseWorkspaceResource"/>.
    /// To get a <see cref="SynapseDedicatedSqlMinimalTlsSettingCollection"/> instance call the GetSynapseDedicatedSqlMinimalTlsSettings method from an instance of <see cref="SynapseWorkspaceResource"/>.
    /// </summary>
    public partial class SynapseDedicatedSqlMinimalTlsSettingCollection : ArmCollection, IEnumerable<SynapseDedicatedSqlMinimalTlsSettingResource>, IAsyncEnumerable<SynapseDedicatedSqlMinimalTlsSettingResource>
    {
        private readonly ClientDiagnostics _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics;
        private readonly WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestOperations _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapseDedicatedSqlMinimalTlsSettingCollection"/> class for mocking. </summary>
        protected SynapseDedicatedSqlMinimalTlsSettingCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseDedicatedSqlMinimalTlsSettingCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapseDedicatedSqlMinimalTlsSettingCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseDedicatedSqlMinimalTlsSettingResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseDedicatedSqlMinimalTlsSettingResource.ResourceType, out string synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsApiVersion);
            _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient = new WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SynapseWorkspaceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SynapseWorkspaceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Update workspace managed sql server's minimal tls settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="data"> minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SynapseDedicatedSqlMinimalTlsSettingResource>> CreateOrUpdateAsync(WaitUntil waitUntil, SynapseDedicatedSqlMinimalTlsSettingName dedicatedSQLminimalTlsSettingsName, SynapseDedicatedSqlMinimalTlsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, data, cancellationToken).ConfigureAwait(false);
                var operation = new SynapseArmOperation<SynapseDedicatedSqlMinimalTlsSettingResource>(new SynapseDedicatedSqlMinimalTlsSettingOperationSource(Client), _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics, Pipeline, _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.CreateUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Update workspace managed sql server's minimal tls settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="data"> minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SynapseDedicatedSqlMinimalTlsSettingResource> CreateOrUpdate(WaitUntil waitUntil, SynapseDedicatedSqlMinimalTlsSettingName dedicatedSQLminimalTlsSettingsName, SynapseDedicatedSqlMinimalTlsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, data, cancellationToken);
                var operation = new SynapseArmOperation<SynapseDedicatedSqlMinimalTlsSettingResource>(new SynapseDedicatedSqlMinimalTlsSettingOperationSource(Client), _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics, Pipeline, _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.CreateUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get workspace managed sql server's minimal tls settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is null. </exception>
        public virtual async Task<Response<SynapseDedicatedSqlMinimalTlsSettingResource>> GetAsync(string dedicatedSQLminimalTlsSettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dedicatedSQLminimalTlsSettingsName, nameof(dedicatedSQLminimalTlsSettingsName));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseDedicatedSqlMinimalTlsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get workspace managed sql server's minimal tls settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is null. </exception>
        public virtual Response<SynapseDedicatedSqlMinimalTlsSettingResource> Get(string dedicatedSQLminimalTlsSettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dedicatedSQLminimalTlsSettingsName, nameof(dedicatedSQLminimalTlsSettingsName));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.Get");
            scope.Start();
            try
            {
                var response = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseDedicatedSqlMinimalTlsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List workspace managed sql server's minimal tls settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapseDedicatedSqlMinimalTlsSettingResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapseDedicatedSqlMinimalTlsSettingResource(Client, SynapseDedicatedSqlMinimalTlsSettingData.DeserializeSynapseDedicatedSqlMinimalTlsSettingData(e)), _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics, Pipeline, "SynapseDedicatedSqlMinimalTlsSettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List workspace managed sql server's minimal tls settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapseDedicatedSqlMinimalTlsSettingResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapseDedicatedSqlMinimalTlsSettingResource(Client, SynapseDedicatedSqlMinimalTlsSettingData.DeserializeSynapseDedicatedSqlMinimalTlsSettingData(e)), _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics, Pipeline, "SynapseDedicatedSqlMinimalTlsSettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dedicatedSQLminimalTlsSettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dedicatedSQLminimalTlsSettingsName, nameof(dedicatedSQLminimalTlsSettingsName));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is null. </exception>
        public virtual Response<bool> Exists(string dedicatedSQLminimalTlsSettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dedicatedSQLminimalTlsSettingsName, nameof(dedicatedSQLminimalTlsSettingsName));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is null. </exception>
        public virtual async Task<NullableResponse<SynapseDedicatedSqlMinimalTlsSettingResource>> GetIfExistsAsync(string dedicatedSQLminimalTlsSettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dedicatedSQLminimalTlsSettingsName, nameof(dedicatedSQLminimalTlsSettingsName));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapseDedicatedSqlMinimalTlsSettingResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseDedicatedSqlMinimalTlsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDedicatedSqlMinimalTlsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dedicatedSQLminimalTlsSettingsName"> The name of the dedicated sql minimal tls settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dedicatedSQLminimalTlsSettingsName"/> is null. </exception>
        public virtual NullableResponse<SynapseDedicatedSqlMinimalTlsSettingResource> GetIfExists(string dedicatedSQLminimalTlsSettingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dedicatedSQLminimalTlsSettingsName, nameof(dedicatedSQLminimalTlsSettingsName));

            using var scope = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsClientDiagnostics.CreateScope("SynapseDedicatedSqlMinimalTlsSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapseDedicatedSqlMinimalTlsSettingWorkspaceManagedSqlServerDedicatedSQLMinimalTlsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dedicatedSQLminimalTlsSettingsName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapseDedicatedSqlMinimalTlsSettingResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseDedicatedSqlMinimalTlsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SynapseDedicatedSqlMinimalTlsSettingResource> IEnumerable<SynapseDedicatedSqlMinimalTlsSettingResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SynapseDedicatedSqlMinimalTlsSettingResource> IAsyncEnumerable<SynapseDedicatedSqlMinimalTlsSettingResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
