// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A Class representing a SynapseDataWarehouseUserActivity along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SynapseDataWarehouseUserActivityResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSynapseDataWarehouseUserActivityResource method.
    /// Otherwise you can get one from its parent resource <see cref="SynapseSqlPoolResource"/> using the GetSynapseDataWarehouseUserActivity method.
    /// </summary>
    public partial class SynapseDataWarehouseUserActivityResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SynapseDataWarehouseUserActivityResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="workspaceName"> The workspaceName. </param>
        /// <param name="sqlPoolName"> The sqlPoolName. </param>
        /// <param name="dataWarehouseUserActivityName"> The dataWarehouseUserActivityName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseDataWarehouseUserActivityName dataWarehouseUserActivityName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics;
        private readonly SqlPoolDataWarehouseUserActivitiesRestOperations _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient;
        private readonly SynapseDataWarehouseUserActivityData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Synapse/workspaces/sqlPools/dataWarehouseUserActivities";

        /// <summary> Initializes a new instance of the <see cref="SynapseDataWarehouseUserActivityResource"/> class for mocking. </summary>
        protected SynapseDataWarehouseUserActivityResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseDataWarehouseUserActivityResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SynapseDataWarehouseUserActivityResource(ArmClient client, SynapseDataWarehouseUserActivityData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseDataWarehouseUserActivityResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SynapseDataWarehouseUserActivityResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesApiVersion);
            _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient = new SqlPoolDataWarehouseUserActivitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SynapseDataWarehouseUserActivityData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the user activities of a SQL pool which includes running and suspended queries
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SynapseDataWarehouseUserActivityResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityResource.Get");
            scope.Start();
            try
            {
                var response = await _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseDataWarehouseUserActivityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the user activities of a SQL pool which includes running and suspended queries
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SynapseDataWarehouseUserActivityResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityResource.Get");
            scope.Start();
            try
            {
                var response = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseDataWarehouseUserActivityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
