// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapseDataWarehouseUserActivityResource"/> and their operations.
    /// Each <see cref="SynapseDataWarehouseUserActivityResource"/> in the collection will belong to the same instance of <see cref="SynapseSqlPoolResource"/>.
    /// To get a <see cref="SynapseDataWarehouseUserActivityCollection"/> instance call the GetSynapseDataWarehouseUserActivities method from an instance of <see cref="SynapseSqlPoolResource"/>.
    /// </summary>
    public partial class SynapseDataWarehouseUserActivityCollection : ArmCollection
    {
        private readonly ClientDiagnostics _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics;
        private readonly SqlPoolDataWarehouseUserActivitiesRestOperations _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapseDataWarehouseUserActivityCollection"/> class for mocking. </summary>
        protected SynapseDataWarehouseUserActivityCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseDataWarehouseUserActivityCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapseDataWarehouseUserActivityCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseDataWarehouseUserActivityResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseDataWarehouseUserActivityResource.ResourceType, out string synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesApiVersion);
            _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient = new SqlPoolDataWarehouseUserActivitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SynapseSqlPoolResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SynapseSqlPoolResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the user activities of a SQL pool which includes running and suspended queries
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataWarehouseUserActivityName"> The activity name of the Sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SynapseDataWarehouseUserActivityResource>> GetAsync(SynapseDataWarehouseUserActivityName dataWarehouseUserActivityName, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, dataWarehouseUserActivityName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseDataWarehouseUserActivityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the user activities of a SQL pool which includes running and suspended queries
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataWarehouseUserActivityName"> The activity name of the Sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SynapseDataWarehouseUserActivityResource> Get(SynapseDataWarehouseUserActivityName dataWarehouseUserActivityName, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityCollection.Get");
            scope.Start();
            try
            {
                var response = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, dataWarehouseUserActivityName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseDataWarehouseUserActivityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataWarehouseUserActivityName"> The activity name of the Sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(SynapseDataWarehouseUserActivityName dataWarehouseUserActivityName, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, dataWarehouseUserActivityName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataWarehouseUserActivityName"> The activity name of the Sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(SynapseDataWarehouseUserActivityName dataWarehouseUserActivityName, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, dataWarehouseUserActivityName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataWarehouseUserActivityName"> The activity name of the Sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<SynapseDataWarehouseUserActivityResource>> GetIfExistsAsync(SynapseDataWarehouseUserActivityName dataWarehouseUserActivityName, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, dataWarehouseUserActivityName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapseDataWarehouseUserActivityResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseDataWarehouseUserActivityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlPoolDataWarehouseUserActivities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseDataWarehouseUserActivityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataWarehouseUserActivityName"> The activity name of the Sql pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<SynapseDataWarehouseUserActivityResource> GetIfExists(SynapseDataWarehouseUserActivityName dataWarehouseUserActivityName, CancellationToken cancellationToken = default)
        {
            using var scope = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesClientDiagnostics.CreateScope("SynapseDataWarehouseUserActivityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapseDataWarehouseUserActivitySqlPoolDataWarehouseUserActivitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, dataWarehouseUserActivityName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapseDataWarehouseUserActivityResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseDataWarehouseUserActivityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
