// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing the SynapseDataMaskingRule data model.
    /// Represents a Sql pool data masking rule.
    /// </summary>
    public partial class SynapseDataMaskingRuleData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseDataMaskingRuleData"/>. </summary>
        public SynapseDataMaskingRuleData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SynapseDataMaskingRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the data masking rule. </param>
        /// <param name="kind"> The kind of Data Masking Rule. Metadata, used for Azure portal. </param>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="aliasName"> The alias name. This is a legacy parameter and is no longer used. </param>
        /// <param name="ruleState"> The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. </param>
        /// <param name="schemaName"> The schema name on which the data masking rule is applied. </param>
        /// <param name="tableName"> The table name on which the data masking rule is applied. </param>
        /// <param name="columnName"> The column name on which the data masking rule is applied. </param>
        /// <param name="maskingFunction"> The masking function that is used for the data masking rule. </param>
        /// <param name="numberFrom"> The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored. </param>
        /// <param name="numberTo"> The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored. </param>
        /// <param name="prefixSize"> If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored. </param>
        /// <param name="suffixSize"> If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored. </param>
        /// <param name="replacementString"> If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseDataMaskingRuleData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, string kind, string ruleId, string aliasName, SynapseDataMaskingRuleState? ruleState, string schemaName, string tableName, string columnName, SynapseDataMaskingFunction? maskingFunction, string numberFrom, string numberTo, string prefixSize, string suffixSize, string replacementString, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Location = location;
            Kind = kind;
            RuleId = ruleId;
            AliasName = aliasName;
            RuleState = ruleState;
            SchemaName = schemaName;
            TableName = tableName;
            ColumnName = columnName;
            MaskingFunction = maskingFunction;
            NumberFrom = numberFrom;
            NumberTo = numberTo;
            PrefixSize = prefixSize;
            SuffixSize = suffixSize;
            ReplacementString = replacementString;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The location of the data masking rule. </summary>
        public AzureLocation? Location { get; }
        /// <summary> The kind of Data Masking Rule. Metadata, used for Azure portal. </summary>
        public string Kind { get; }
        /// <summary> The rule Id. </summary>
        public string RuleId { get; }
        /// <summary> The alias name. This is a legacy parameter and is no longer used. </summary>
        public string AliasName { get; set; }
        /// <summary> The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. </summary>
        public SynapseDataMaskingRuleState? RuleState { get; set; }
        /// <summary> The schema name on which the data masking rule is applied. </summary>
        public string SchemaName { get; set; }
        /// <summary> The table name on which the data masking rule is applied. </summary>
        public string TableName { get; set; }
        /// <summary> The column name on which the data masking rule is applied. </summary>
        public string ColumnName { get; set; }
        /// <summary> The masking function that is used for the data masking rule. </summary>
        public SynapseDataMaskingFunction? MaskingFunction { get; set; }
        /// <summary> The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored. </summary>
        public string NumberFrom { get; set; }
        /// <summary> The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored. </summary>
        public string NumberTo { get; set; }
        /// <summary> If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored. </summary>
        public string PrefixSize { get; set; }
        /// <summary> If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored. </summary>
        public string SuffixSize { get; set; }
        /// <summary> If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored. </summary>
        public string ReplacementString { get; set; }
    }
}
