// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Synapse
{
    /// <summary>
    /// A class representing a collection of <see cref="SynapseBigDataPoolInfoResource"/> and their operations.
    /// Each <see cref="SynapseBigDataPoolInfoResource"/> in the collection will belong to the same instance of <see cref="SynapseWorkspaceResource"/>.
    /// To get a <see cref="SynapseBigDataPoolInfoCollection"/> instance call the GetSynapseBigDataPoolInfos method from an instance of <see cref="SynapseWorkspaceResource"/>.
    /// </summary>
    public partial class SynapseBigDataPoolInfoCollection : ArmCollection, IEnumerable<SynapseBigDataPoolInfoResource>, IAsyncEnumerable<SynapseBigDataPoolInfoResource>
    {
        private readonly ClientDiagnostics _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics;
        private readonly BigDataPoolsRestOperations _synapseBigDataPoolInfoBigDataPoolsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SynapseBigDataPoolInfoCollection"/> class for mocking. </summary>
        protected SynapseBigDataPoolInfoCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SynapseBigDataPoolInfoCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SynapseBigDataPoolInfoCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Synapse", SynapseBigDataPoolInfoResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SynapseBigDataPoolInfoResource.ResourceType, out string synapseBigDataPoolInfoBigDataPoolsApiVersion);
            _synapseBigDataPoolInfoBigDataPoolsRestClient = new BigDataPoolsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, synapseBigDataPoolInfoBigDataPoolsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SynapseWorkspaceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SynapseWorkspaceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a new Big Data pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="info"> The Big Data pool to create. </param>
        /// <param name="force"> Whether to stop any running jobs in the Big Data pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> or <paramref name="info"/> is null. </exception>
        public virtual async Task<ArmOperation<SynapseBigDataPoolInfoResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string bigDataPoolName, SynapseBigDataPoolInfoData info, bool? force = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));
            Argument.AssertNotNull(info, nameof(info));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, info, force, cancellationToken).ConfigureAwait(false);
                var operation = new SynapseArmOperation<SynapseBigDataPoolInfoResource>(new SynapseBigDataPoolInfoOperationSource(Client), _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics, Pipeline, _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, info, force).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a new Big Data pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="info"> The Big Data pool to create. </param>
        /// <param name="force"> Whether to stop any running jobs in the Big Data pool. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> or <paramref name="info"/> is null. </exception>
        public virtual ArmOperation<SynapseBigDataPoolInfoResource> CreateOrUpdate(WaitUntil waitUntil, string bigDataPoolName, SynapseBigDataPoolInfoData info, bool? force = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));
            Argument.AssertNotNull(info, nameof(info));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, info, force, cancellationToken);
                var operation = new SynapseArmOperation<SynapseBigDataPoolInfoResource>(new SynapseBigDataPoolInfoOperationSource(Client), _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics, Pipeline, _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, info, force).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a Big Data pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> is null. </exception>
        public virtual async Task<Response<SynapseBigDataPoolInfoResource>> GetAsync(string bigDataPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.Get");
            scope.Start();
            try
            {
                var response = await _synapseBigDataPoolInfoBigDataPoolsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseBigDataPoolInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a Big Data pool.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> is null. </exception>
        public virtual Response<SynapseBigDataPoolInfoResource> Get(string bigDataPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.Get");
            scope.Start();
            try
            {
                var response = _synapseBigDataPoolInfoBigDataPoolsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SynapseBigDataPoolInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List Big Data pools in a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_ListByWorkspace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SynapseBigDataPoolInfoResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SynapseBigDataPoolInfoResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateListByWorkspaceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateListByWorkspaceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SynapseBigDataPoolInfoResource(Client, SynapseBigDataPoolInfoData.DeserializeSynapseBigDataPoolInfoData(e)), _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics, Pipeline, "SynapseBigDataPoolInfoCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List Big Data pools in a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_ListByWorkspace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SynapseBigDataPoolInfoResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SynapseBigDataPoolInfoResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateListByWorkspaceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _synapseBigDataPoolInfoBigDataPoolsRestClient.CreateListByWorkspaceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SynapseBigDataPoolInfoResource(Client, SynapseBigDataPoolInfoData.DeserializeSynapseBigDataPoolInfoData(e)), _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics, Pipeline, "SynapseBigDataPoolInfoCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string bigDataPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.Exists");
            scope.Start();
            try
            {
                var response = await _synapseBigDataPoolInfoBigDataPoolsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> is null. </exception>
        public virtual Response<bool> Exists(string bigDataPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.Exists");
            scope.Start();
            try
            {
                var response = _synapseBigDataPoolInfoBigDataPoolsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> is null. </exception>
        public virtual async Task<NullableResponse<SynapseBigDataPoolInfoResource>> GetIfExistsAsync(string bigDataPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _synapseBigDataPoolInfoBigDataPoolsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SynapseBigDataPoolInfoResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseBigDataPoolInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BigDataPools_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SynapseBigDataPoolInfoResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bigDataPoolName"> Big Data pool name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="bigDataPoolName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="bigDataPoolName"/> is null. </exception>
        public virtual NullableResponse<SynapseBigDataPoolInfoResource> GetIfExists(string bigDataPoolName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(bigDataPoolName, nameof(bigDataPoolName));

            using var scope = _synapseBigDataPoolInfoBigDataPoolsClientDiagnostics.CreateScope("SynapseBigDataPoolInfoCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _synapseBigDataPoolInfoBigDataPoolsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, bigDataPoolName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SynapseBigDataPoolInfoResource>(response.GetRawResponse());
                return Response.FromValue(new SynapseBigDataPoolInfoResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SynapseBigDataPoolInfoResource> IEnumerable<SynapseBigDataPoolInfoResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SynapseBigDataPoolInfoResource> IAsyncEnumerable<SynapseBigDataPoolInfoResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
