// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Synapse.Models;

namespace Azure.ResourceManager.Synapse
{
    internal partial class SqlPoolVulnerabilityAssessmentRuleBaselinesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of SqlPoolVulnerabilityAssessmentRuleBaselinesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public SqlPoolVulnerabilityAssessmentRuleBaselinesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2021-06-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Synapse/workspaces/", false);
            uri.AppendPath(workspaceName, true);
            uri.AppendPath("/sqlPools/", false);
            uri.AppendPath(sqlPoolName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Synapse/workspaces/", false);
            uri.AppendPath(workspaceName, true);
            uri.AppendPath("/sqlPools/", false);
            uri.AppendPath(sqlPoolName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates or updates a Sql pool's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="workspaceName"> The name of the workspace. </param>
        /// <param name="sqlPoolName"> SQL pool name. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/>, <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData>> CreateOrUpdateAsync(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(workspaceName, nameof(workspaceName));
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData.DeserializeSynapseSqlPoolVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates or updates a Sql pool's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="workspaceName"> The name of the workspace. </param>
        /// <param name="sqlPoolName"> SQL pool name. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/>, <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData> CreateOrUpdate(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(workspaceName, nameof(workspaceName));
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData.DeserializeSynapseSqlPoolVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Synapse/workspaces/", false);
            uri.AppendPath(workspaceName, true);
            uri.AppendPath("/sqlPools/", false);
            uri.AppendPath(sqlPoolName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Synapse/workspaces/", false);
            uri.AppendPath(workspaceName, true);
            uri.AppendPath("/sqlPools/", false);
            uri.AppendPath(sqlPoolName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Removes the database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="workspaceName"> The name of the workspace. </param>
        /// <param name="sqlPoolName"> SQL pool name. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(workspaceName, nameof(workspaceName));
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Removes the database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="workspaceName"> The name of the workspace. </param>
        /// <param name="sqlPoolName"> SQL pool name. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(workspaceName, nameof(workspaceName));
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Synapse/workspaces/", false);
            uri.AppendPath(workspaceName, true);
            uri.AppendPath("/sqlPools/", false);
            uri.AppendPath(sqlPoolName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Synapse/workspaces/", false);
            uri.AppendPath(workspaceName, true);
            uri.AppendPath("/sqlPools/", false);
            uri.AppendPath(sqlPoolName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a SqlPool's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="workspaceName"> The name of the workspace. </param>
        /// <param name="sqlPoolName"> SQL pool name. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData>> GetAsync(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(workspaceName, nameof(workspaceName));
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData.DeserializeSynapseSqlPoolVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a SqlPool's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="workspaceName"> The name of the workspace. </param>
        /// <param name="sqlPoolName"> SQL pool name. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="workspaceName"/>, <paramref name="sqlPoolName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData> Get(string subscriptionId, string resourceGroupName, string workspaceName, string sqlPoolName, SynapseVulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, SynapseVulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(workspaceName, nameof(workspaceName));
            Argument.AssertNotNullOrEmpty(sqlPoolName, nameof(sqlPoolName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, workspaceName, sqlPoolName, vulnerabilityAssessmentName, ruleId, baselineName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData.DeserializeSynapseSqlPoolVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SynapseSqlPoolVulnerabilityAssessmentRuleBaselineData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
