// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Enable or Disable public network access to workspace. </summary>
    public readonly partial struct WorkspacePublicNetworkAccess : IEquatable<WorkspacePublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkspacePublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkspacePublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static WorkspacePublicNetworkAccess Enabled { get; } = new WorkspacePublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static WorkspacePublicNetworkAccess Disabled { get; } = new WorkspacePublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="WorkspacePublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(WorkspacePublicNetworkAccess left, WorkspacePublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkspacePublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(WorkspacePublicNetworkAccess left, WorkspacePublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkspacePublicNetworkAccess"/>. </summary>
        public static implicit operator WorkspacePublicNetworkAccess(string value) => new WorkspacePublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkspacePublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkspacePublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
