// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The scan trigger type. </summary>
    public readonly partial struct SynapseVulnerabilityAssessmentScanTriggerType : IEquatable<SynapseVulnerabilityAssessmentScanTriggerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseVulnerabilityAssessmentScanTriggerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseVulnerabilityAssessmentScanTriggerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnDemandValue = "OnDemand";
        private const string RecurringValue = "Recurring";

        /// <summary> OnDemand. </summary>
        public static SynapseVulnerabilityAssessmentScanTriggerType OnDemand { get; } = new SynapseVulnerabilityAssessmentScanTriggerType(OnDemandValue);
        /// <summary> Recurring. </summary>
        public static SynapseVulnerabilityAssessmentScanTriggerType Recurring { get; } = new SynapseVulnerabilityAssessmentScanTriggerType(RecurringValue);
        /// <summary> Determines if two <see cref="SynapseVulnerabilityAssessmentScanTriggerType"/> values are the same. </summary>
        public static bool operator ==(SynapseVulnerabilityAssessmentScanTriggerType left, SynapseVulnerabilityAssessmentScanTriggerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseVulnerabilityAssessmentScanTriggerType"/> values are not the same. </summary>
        public static bool operator !=(SynapseVulnerabilityAssessmentScanTriggerType left, SynapseVulnerabilityAssessmentScanTriggerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseVulnerabilityAssessmentScanTriggerType"/>. </summary>
        public static implicit operator SynapseVulnerabilityAssessmentScanTriggerType(string value) => new SynapseVulnerabilityAssessmentScanTriggerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseVulnerabilityAssessmentScanTriggerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseVulnerabilityAssessmentScanTriggerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
