// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The scan status. </summary>
    public readonly partial struct SynapseVulnerabilityAssessmentScanState : IEquatable<SynapseVulnerabilityAssessmentScanState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseVulnerabilityAssessmentScanState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseVulnerabilityAssessmentScanState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PassedValue = "Passed";
        private const string FailedValue = "Failed";
        private const string FailedToRunValue = "FailedToRun";
        private const string InProgressValue = "InProgress";

        /// <summary> Passed. </summary>
        public static SynapseVulnerabilityAssessmentScanState Passed { get; } = new SynapseVulnerabilityAssessmentScanState(PassedValue);
        /// <summary> Failed. </summary>
        public static SynapseVulnerabilityAssessmentScanState Failed { get; } = new SynapseVulnerabilityAssessmentScanState(FailedValue);
        /// <summary> FailedToRun. </summary>
        public static SynapseVulnerabilityAssessmentScanState FailedToRun { get; } = new SynapseVulnerabilityAssessmentScanState(FailedToRunValue);
        /// <summary> InProgress. </summary>
        public static SynapseVulnerabilityAssessmentScanState InProgress { get; } = new SynapseVulnerabilityAssessmentScanState(InProgressValue);
        /// <summary> Determines if two <see cref="SynapseVulnerabilityAssessmentScanState"/> values are the same. </summary>
        public static bool operator ==(SynapseVulnerabilityAssessmentScanState left, SynapseVulnerabilityAssessmentScanState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseVulnerabilityAssessmentScanState"/> values are not the same. </summary>
        public static bool operator !=(SynapseVulnerabilityAssessmentScanState left, SynapseVulnerabilityAssessmentScanState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseVulnerabilityAssessmentScanState"/>. </summary>
        public static implicit operator SynapseVulnerabilityAssessmentScanState(string value) => new SynapseVulnerabilityAssessmentScanState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseVulnerabilityAssessmentScanState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseVulnerabilityAssessmentScanState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
