// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Properties of a Vulnerability Assessment recurring scans. </summary>
    public partial class SynapseVulnerabilityAssessmentRecurringScansProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseVulnerabilityAssessmentRecurringScansProperties"/>. </summary>
        public SynapseVulnerabilityAssessmentRecurringScansProperties()
        {
            Emails = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SynapseVulnerabilityAssessmentRecurringScansProperties"/>. </summary>
        /// <param name="isEnabled"> Recurring scans state. </param>
        /// <param name="enableEmailToAccountAdmins"> Specifies that the schedule scan notification will be is sent to the subscription administrators. </param>
        /// <param name="emails"> Specifies an array of e-mail addresses to which the scan notification is sent. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseVulnerabilityAssessmentRecurringScansProperties(bool? isEnabled, bool? enableEmailToAccountAdmins, IList<string> emails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            EnableEmailToAccountAdmins = enableEmailToAccountAdmins;
            Emails = emails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Recurring scans state. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> Specifies that the schedule scan notification will be is sent to the subscription administrators. </summary>
        public bool? EnableEmailToAccountAdmins { get; set; }
        /// <summary> Specifies an array of e-mail addresses to which the scan notification is sent. </summary>
        public IList<string> Emails { get; }
    }
}
