// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Synapse.Models
{
    public partial class SynapseVulnerabilityAssessmentRecurringScansProperties : IUtf8JsonSerializable, IJsonModel<SynapseVulnerabilityAssessmentRecurringScansProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SynapseVulnerabilityAssessmentRecurringScansProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SynapseVulnerabilityAssessmentRecurringScansProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentRecurringScansProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentRecurringScansProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IsEnabled))
            {
                writer.WritePropertyName("isEnabled"u8);
                writer.WriteBooleanValue(IsEnabled.Value);
            }
            if (Optional.IsDefined(EnableEmailToAccountAdmins))
            {
                writer.WritePropertyName("emailSubscriptionAdmins"u8);
                writer.WriteBooleanValue(EnableEmailToAccountAdmins.Value);
            }
            if (Optional.IsCollectionDefined(Emails))
            {
                writer.WritePropertyName("emails"u8);
                writer.WriteStartArray();
                foreach (var item in Emails)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SynapseVulnerabilityAssessmentRecurringScansProperties IJsonModel<SynapseVulnerabilityAssessmentRecurringScansProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentRecurringScansProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentRecurringScansProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSynapseVulnerabilityAssessmentRecurringScansProperties(document.RootElement, options);
        }

        internal static SynapseVulnerabilityAssessmentRecurringScansProperties DeserializeSynapseVulnerabilityAssessmentRecurringScansProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? isEnabled = default;
            bool? emailSubscriptionAdmins = default;
            IList<string> emails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("emailSubscriptionAdmins"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    emailSubscriptionAdmins = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("emails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    emails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SynapseVulnerabilityAssessmentRecurringScansProperties(isEnabled, emailSubscriptionAdmins, emails ?? new ChangeTrackingList<string>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SynapseVulnerabilityAssessmentRecurringScansProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentRecurringScansProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentRecurringScansProperties)} does not support writing '{options.Format}' format.");
            }
        }

        SynapseVulnerabilityAssessmentRecurringScansProperties IPersistableModel<SynapseVulnerabilityAssessmentRecurringScansProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseVulnerabilityAssessmentRecurringScansProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSynapseVulnerabilityAssessmentRecurringScansProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SynapseVulnerabilityAssessmentRecurringScansProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SynapseVulnerabilityAssessmentRecurringScansProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
