// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The SynapseVulnerabilityAssessmentName. </summary>
    public readonly partial struct SynapseVulnerabilityAssessmentName : IEquatable<SynapseVulnerabilityAssessmentName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseVulnerabilityAssessmentName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseVulnerabilityAssessmentName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static SynapseVulnerabilityAssessmentName Default { get; } = new SynapseVulnerabilityAssessmentName(DefaultValue);
        /// <summary> Determines if two <see cref="SynapseVulnerabilityAssessmentName"/> values are the same. </summary>
        public static bool operator ==(SynapseVulnerabilityAssessmentName left, SynapseVulnerabilityAssessmentName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseVulnerabilityAssessmentName"/> values are not the same. </summary>
        public static bool operator !=(SynapseVulnerabilityAssessmentName left, SynapseVulnerabilityAssessmentName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseVulnerabilityAssessmentName"/>. </summary>
        public static implicit operator SynapseVulnerabilityAssessmentName(string value) => new SynapseVulnerabilityAssessmentName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseVulnerabilityAssessmentName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseVulnerabilityAssessmentName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
