// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The type of SSIS object metadata. </summary>
    internal readonly partial struct SynapseSsisObjectMetadataType : IEquatable<SynapseSsisObjectMetadataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseSsisObjectMetadataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseSsisObjectMetadataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FolderValue = "Folder";
        private const string ProjectValue = "Project";
        private const string PackageValue = "Package";
        private const string EnvironmentValue = "Environment";

        /// <summary> Folder. </summary>
        public static SynapseSsisObjectMetadataType Folder { get; } = new SynapseSsisObjectMetadataType(FolderValue);
        /// <summary> Project. </summary>
        public static SynapseSsisObjectMetadataType Project { get; } = new SynapseSsisObjectMetadataType(ProjectValue);
        /// <summary> Package. </summary>
        public static SynapseSsisObjectMetadataType Package { get; } = new SynapseSsisObjectMetadataType(PackageValue);
        /// <summary> Environment. </summary>
        public static SynapseSsisObjectMetadataType Environment { get; } = new SynapseSsisObjectMetadataType(EnvironmentValue);
        /// <summary> Determines if two <see cref="SynapseSsisObjectMetadataType"/> values are the same. </summary>
        public static bool operator ==(SynapseSsisObjectMetadataType left, SynapseSsisObjectMetadataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseSsisObjectMetadataType"/> values are not the same. </summary>
        public static bool operator !=(SynapseSsisObjectMetadataType left, SynapseSsisObjectMetadataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseSsisObjectMetadataType"/>. </summary>
        public static implicit operator SynapseSsisObjectMetadataType(string value) => new SynapseSsisObjectMetadataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseSsisObjectMetadataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseSsisObjectMetadataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
