// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Ssis environment. </summary>
    public partial class SynapseSsisEnvironment : SynapseSsisObjectMetadata
    {
        /// <summary> Initializes a new instance of <see cref="SynapseSsisEnvironment"/>. </summary>
        internal SynapseSsisEnvironment()
        {
            Variables = new ChangeTrackingList<SynapseSsisVariable>();
            MetadataType = SynapseSsisObjectMetadataType.Environment;
        }

        /// <summary> Initializes a new instance of <see cref="SynapseSsisEnvironment"/>. </summary>
        /// <param name="metadataType"> Type of metadata. </param>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="folderId"> Folder id which contains environment. </param>
        /// <param name="variables"> Variable in environment. </param>
        internal SynapseSsisEnvironment(SynapseSsisObjectMetadataType metadataType, long? id, string name, string description, IDictionary<string, BinaryData> serializedAdditionalRawData, long? folderId, IReadOnlyList<SynapseSsisVariable> variables) : base(metadataType, id, name, description, serializedAdditionalRawData)
        {
            FolderId = folderId;
            Variables = variables;
            MetadataType = metadataType;
        }

        /// <summary> Folder id which contains environment. </summary>
        public long? FolderId { get; }
        /// <summary> Variable in environment. </summary>
        public IReadOnlyList<SynapseSsisVariable> Variables { get; }
    }
}
