// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The type of the spark config properties file. </summary>
    public readonly partial struct SynapseSparkConfigurationType : IEquatable<SynapseSparkConfigurationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseSparkConfigurationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseSparkConfigurationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FileValue = "File";
        private const string ArtifactValue = "Artifact";

        /// <summary> File. </summary>
        public static SynapseSparkConfigurationType File { get; } = new SynapseSparkConfigurationType(FileValue);
        /// <summary> Artifact. </summary>
        public static SynapseSparkConfigurationType Artifact { get; } = new SynapseSparkConfigurationType(ArtifactValue);
        /// <summary> Determines if two <see cref="SynapseSparkConfigurationType"/> values are the same. </summary>
        public static bool operator ==(SynapseSparkConfigurationType left, SynapseSparkConfigurationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseSparkConfigurationType"/> values are not the same. </summary>
        public static bool operator !=(SynapseSparkConfigurationType left, SynapseSparkConfigurationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseSparkConfigurationType"/>. </summary>
        public static implicit operator SynapseSparkConfigurationType(string value) => new SynapseSparkConfigurationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseSparkConfigurationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseSparkConfigurationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
