// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> SKU name. </summary>
    public readonly partial struct SynapseSkuName : IEquatable<SynapseSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ComputeOptimizedValue = "Compute optimized";
        private const string StorageOptimizedValue = "Storage optimized";

        /// <summary> Compute optimized. </summary>
        public static SynapseSkuName ComputeOptimized { get; } = new SynapseSkuName(ComputeOptimizedValue);
        /// <summary> Storage optimized. </summary>
        public static SynapseSkuName StorageOptimized { get; } = new SynapseSkuName(StorageOptimizedValue);
        /// <summary> Determines if two <see cref="SynapseSkuName"/> values are the same. </summary>
        public static bool operator ==(SynapseSkuName left, SynapseSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseSkuName"/> values are not the same. </summary>
        public static bool operator !=(SynapseSkuName left, SynapseSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseSkuName"/>. </summary>
        public static implicit operator SynapseSkuName(string value) => new SynapseSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
