// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. </summary>
    public readonly partial struct SynapseServerKeyType : IEquatable<SynapseServerKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseServerKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseServerKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServiceManagedValue = "ServiceManaged";
        private const string AzureKeyVaultValue = "AzureKeyVault";

        /// <summary> ServiceManaged. </summary>
        public static SynapseServerKeyType ServiceManaged { get; } = new SynapseServerKeyType(ServiceManagedValue);
        /// <summary> AzureKeyVault. </summary>
        public static SynapseServerKeyType AzureKeyVault { get; } = new SynapseServerKeyType(AzureKeyVaultValue);
        /// <summary> Determines if two <see cref="SynapseServerKeyType"/> values are the same. </summary>
        public static bool operator ==(SynapseServerKeyType left, SynapseServerKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseServerKeyType"/> values are not the same. </summary>
        public static bool operator !=(SynapseServerKeyType left, SynapseServerKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseServerKeyType"/>. </summary>
        public static implicit operator SynapseServerKeyType(string value) => new SynapseServerKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseServerKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseServerKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
