// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Synapse.Models
{
    internal static partial class SynapseRestorePointTypeExtensions
    {
        public static string ToSerialString(this SynapseRestorePointType value) => value switch
        {
            SynapseRestorePointType.Continuous => "CONTINUOUS",
            SynapseRestorePointType.Discrete => "DISCRETE",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SynapseRestorePointType value.")
        };

        public static SynapseRestorePointType ToSynapseRestorePointType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CONTINUOUS")) return SynapseRestorePointType.Continuous;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DISCRETE")) return SynapseRestorePointType.Discrete;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SynapseRestorePointType value.");
        }
    }
}
