// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Synapse.Models
{
    internal static partial class SynapseReplicationRoleExtensions
    {
        public static string ToSerialString(this SynapseReplicationRole value) => value switch
        {
            SynapseReplicationRole.Primary => "Primary",
            SynapseReplicationRole.Secondary => "Secondary",
            SynapseReplicationRole.NonReadableSecondary => "NonReadableSecondary",
            SynapseReplicationRole.Source => "Source",
            SynapseReplicationRole.Copy => "Copy",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SynapseReplicationRole value.")
        };

        public static SynapseReplicationRole ToSynapseReplicationRole(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return SynapseReplicationRole.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return SynapseReplicationRole.Secondary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NonReadableSecondary")) return SynapseReplicationRole.NonReadableSecondary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Source")) return SynapseReplicationRole.Source;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Copy")) return SynapseReplicationRole.Copy;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SynapseReplicationRole value.");
        }
    }
}
