// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Resource provisioning state. </summary>
    public readonly partial struct SynapseProvisioningState : IEquatable<SynapseProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string DeleteErrorValue = "DeleteError";

        /// <summary> Provisioning. </summary>
        public static SynapseProvisioningState Provisioning { get; } = new SynapseProvisioningState(ProvisioningValue);
        /// <summary> Succeeded. </summary>
        public static SynapseProvisioningState Succeeded { get; } = new SynapseProvisioningState(SucceededValue);
        /// <summary> Deleting. </summary>
        public static SynapseProvisioningState Deleting { get; } = new SynapseProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static SynapseProvisioningState Failed { get; } = new SynapseProvisioningState(FailedValue);
        /// <summary> DeleteError. </summary>
        public static SynapseProvisioningState DeleteError { get; } = new SynapseProvisioningState(DeleteErrorValue);
        /// <summary> Determines if two <see cref="SynapseProvisioningState"/> values are the same. </summary>
        public static bool operator ==(SynapseProvisioningState left, SynapseProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(SynapseProvisioningState left, SynapseProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseProvisioningState"/>. </summary>
        public static implicit operator SynapseProvisioningState(string value) => new SynapseProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
