// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The principals modification kind of the database. </summary>
    public readonly partial struct SynapsePrincipalsModificationKind : IEquatable<SynapsePrincipalsModificationKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapsePrincipalsModificationKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapsePrincipalsModificationKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnionValue = "Union";
        private const string ReplaceValue = "Replace";
        private const string NoneValue = "None";

        /// <summary> Union. </summary>
        public static SynapsePrincipalsModificationKind Union { get; } = new SynapsePrincipalsModificationKind(UnionValue);
        /// <summary> Replace. </summary>
        public static SynapsePrincipalsModificationKind Replace { get; } = new SynapsePrincipalsModificationKind(ReplaceValue);
        /// <summary> None. </summary>
        public static SynapsePrincipalsModificationKind None { get; } = new SynapsePrincipalsModificationKind(NoneValue);
        /// <summary> Determines if two <see cref="SynapsePrincipalsModificationKind"/> values are the same. </summary>
        public static bool operator ==(SynapsePrincipalsModificationKind left, SynapsePrincipalsModificationKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapsePrincipalsModificationKind"/> values are not the same. </summary>
        public static bool operator !=(SynapsePrincipalsModificationKind left, SynapsePrincipalsModificationKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapsePrincipalsModificationKind"/>. </summary>
        public static implicit operator SynapsePrincipalsModificationKind(string value) => new SynapsePrincipalsModificationKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapsePrincipalsModificationKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapsePrincipalsModificationKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
