// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The type of resource, Microsoft.Synapse/workspaces/kustoPools/principalAssignments. </summary>
    public readonly partial struct SynapsePrincipalAssignmentType : IEquatable<SynapsePrincipalAssignmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapsePrincipalAssignmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapsePrincipalAssignmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftSynapseWorkspacesKustoPoolsPrincipalAssignmentsValue = "Microsoft.Synapse/workspaces/kustoPools/principalAssignments";

        /// <summary> Microsoft.Synapse/workspaces/kustoPools/principalAssignments. </summary>
        public static SynapsePrincipalAssignmentType MicrosoftSynapseWorkspacesKustoPoolsPrincipalAssignments { get; } = new SynapsePrincipalAssignmentType(MicrosoftSynapseWorkspacesKustoPoolsPrincipalAssignmentsValue);
        /// <summary> Determines if two <see cref="SynapsePrincipalAssignmentType"/> values are the same. </summary>
        public static bool operator ==(SynapsePrincipalAssignmentType left, SynapsePrincipalAssignmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapsePrincipalAssignmentType"/> values are not the same. </summary>
        public static bool operator !=(SynapsePrincipalAssignmentType left, SynapsePrincipalAssignmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapsePrincipalAssignmentType"/>. </summary>
        public static implicit operator SynapsePrincipalAssignmentType(string value) => new SynapsePrincipalAssignmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapsePrincipalAssignmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapsePrincipalAssignmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
