// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> A class that contains the optimized auto scale definition. </summary>
    public partial class SynapseOptimizedAutoscale
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseOptimizedAutoscale"/>. </summary>
        /// <param name="version"> The version of the template defined, for instance 1. </param>
        /// <param name="isEnabled"> A boolean value that indicate if the optimized autoscale feature is enabled or not. </param>
        /// <param name="minimum"> Minimum allowed instances count. </param>
        /// <param name="maximum"> Maximum allowed instances count. </param>
        public SynapseOptimizedAutoscale(int version, bool isEnabled, int minimum, int maximum)
        {
            Version = version;
            IsEnabled = isEnabled;
            Minimum = minimum;
            Maximum = maximum;
        }

        /// <summary> Initializes a new instance of <see cref="SynapseOptimizedAutoscale"/>. </summary>
        /// <param name="version"> The version of the template defined, for instance 1. </param>
        /// <param name="isEnabled"> A boolean value that indicate if the optimized autoscale feature is enabled or not. </param>
        /// <param name="minimum"> Minimum allowed instances count. </param>
        /// <param name="maximum"> Maximum allowed instances count. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseOptimizedAutoscale(int version, bool isEnabled, int minimum, int maximum, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Version = version;
            IsEnabled = isEnabled;
            Minimum = minimum;
            Maximum = maximum;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SynapseOptimizedAutoscale"/> for deserialization. </summary>
        internal SynapseOptimizedAutoscale()
        {
        }

        /// <summary> The version of the template defined, for instance 1. </summary>
        public int Version { get; set; }
        /// <summary> A boolean value that indicate if the optimized autoscale feature is enabled or not. </summary>
        public bool IsEnabled { get; set; }
        /// <summary> Minimum allowed instances count. </summary>
        public int Minimum { get; set; }
        /// <summary> Maximum allowed instances count. </summary>
        public int Maximum { get; set; }
    }
}
