// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Kind of the database. </summary>
    internal readonly partial struct SynapseKind : IEquatable<SynapseKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadWriteValue = "ReadWrite";
        private const string ReadOnlyFollowingValue = "ReadOnlyFollowing";

        /// <summary> ReadWrite. </summary>
        public static SynapseKind ReadWrite { get; } = new SynapseKind(ReadWriteValue);
        /// <summary> ReadOnlyFollowing. </summary>
        public static SynapseKind ReadOnlyFollowing { get; } = new SynapseKind(ReadOnlyFollowingValue);
        /// <summary> Determines if two <see cref="SynapseKind"/> values are the same. </summary>
        public static bool operator ==(SynapseKind left, SynapseKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseKind"/> values are not the same. </summary>
        public static bool operator !=(SynapseKind left, SynapseKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseKind"/>. </summary>
        public static implicit operator SynapseKind(string value) => new SynapseKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
