// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The data format of the message. Optionally the data format can be added to each message. </summary>
    public readonly partial struct SynapseIotHubDataFormat : IEquatable<SynapseIotHubDataFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseIotHubDataFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseIotHubDataFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MultiJsonValue = "MULTIJSON";
        private const string JsonValue = "JSON";
        private const string CsvValue = "CSV";
        private const string TsvValue = "TSV";
        private const string ScsvValue = "SCSV";
        private const string SohsvValue = "SOHSV";
        private const string PsvValue = "PSV";
        private const string TxtValue = "TXT";
        private const string RawValue = "RAW";
        private const string SingleJsonValue = "SINGLEJSON";
        private const string AvroValue = "AVRO";
        private const string TsveValue = "TSVE";
        private const string ParquetValue = "PARQUET";
        private const string OrcValue = "ORC";
        private const string ApacheAvroValue = "APACHEAVRO";
        private const string W3CLogfileValue = "W3CLOGFILE";

        /// <summary> MULTIJSON. </summary>
        public static SynapseIotHubDataFormat MultiJson { get; } = new SynapseIotHubDataFormat(MultiJsonValue);
        /// <summary> JSON. </summary>
        public static SynapseIotHubDataFormat Json { get; } = new SynapseIotHubDataFormat(JsonValue);
        /// <summary> CSV. </summary>
        public static SynapseIotHubDataFormat Csv { get; } = new SynapseIotHubDataFormat(CsvValue);
        /// <summary> TSV. </summary>
        public static SynapseIotHubDataFormat Tsv { get; } = new SynapseIotHubDataFormat(TsvValue);
        /// <summary> SCSV. </summary>
        public static SynapseIotHubDataFormat Scsv { get; } = new SynapseIotHubDataFormat(ScsvValue);
        /// <summary> SOHSV. </summary>
        public static SynapseIotHubDataFormat Sohsv { get; } = new SynapseIotHubDataFormat(SohsvValue);
        /// <summary> PSV. </summary>
        public static SynapseIotHubDataFormat Psv { get; } = new SynapseIotHubDataFormat(PsvValue);
        /// <summary> TXT. </summary>
        public static SynapseIotHubDataFormat Txt { get; } = new SynapseIotHubDataFormat(TxtValue);
        /// <summary> RAW. </summary>
        public static SynapseIotHubDataFormat Raw { get; } = new SynapseIotHubDataFormat(RawValue);
        /// <summary> SINGLEJSON. </summary>
        public static SynapseIotHubDataFormat SingleJson { get; } = new SynapseIotHubDataFormat(SingleJsonValue);
        /// <summary> AVRO. </summary>
        public static SynapseIotHubDataFormat Avro { get; } = new SynapseIotHubDataFormat(AvroValue);
        /// <summary> TSVE. </summary>
        public static SynapseIotHubDataFormat Tsve { get; } = new SynapseIotHubDataFormat(TsveValue);
        /// <summary> PARQUET. </summary>
        public static SynapseIotHubDataFormat Parquet { get; } = new SynapseIotHubDataFormat(ParquetValue);
        /// <summary> ORC. </summary>
        public static SynapseIotHubDataFormat Orc { get; } = new SynapseIotHubDataFormat(OrcValue);
        /// <summary> APACHEAVRO. </summary>
        public static SynapseIotHubDataFormat ApacheAvro { get; } = new SynapseIotHubDataFormat(ApacheAvroValue);
        /// <summary> W3CLOGFILE. </summary>
        public static SynapseIotHubDataFormat W3CLogfile { get; } = new SynapseIotHubDataFormat(W3CLogfileValue);
        /// <summary> Determines if two <see cref="SynapseIotHubDataFormat"/> values are the same. </summary>
        public static bool operator ==(SynapseIotHubDataFormat left, SynapseIotHubDataFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseIotHubDataFormat"/> values are not the same. </summary>
        public static bool operator !=(SynapseIotHubDataFormat left, SynapseIotHubDataFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseIotHubDataFormat"/>. </summary>
        public static implicit operator SynapseIotHubDataFormat(string value) => new SynapseIotHubDataFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseIotHubDataFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseIotHubDataFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
