// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Class representing an iot hub data connection. </summary>
    public partial class SynapseIotHubDataConnection : SynapseDataConnectionData
    {
        /// <summary> Initializes a new instance of <see cref="SynapseIotHubDataConnection"/>. </summary>
        public SynapseIotHubDataConnection()
        {
            EventSystemProperties = new ChangeTrackingList<string>();
            Kind = SynapseDataConnectionKind.IotHub;
        }

        /// <summary> Initializes a new instance of <see cref="SynapseIotHubDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="kind"> Kind of the endpoint for the data connection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="iotHubResourceId"> The resource ID of the Iot hub to be used to create a data connection. </param>
        /// <param name="consumerGroup"> The iot hub consumer group. </param>
        /// <param name="tableName"> The table where the data should be ingested. Optionally the table information can be added to each message. </param>
        /// <param name="mappingRuleName"> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </param>
        /// <param name="dataFormat"> The data format of the message. Optionally the data format can be added to each message. </param>
        /// <param name="eventSystemProperties"> System properties of the iot hub. </param>
        /// <param name="sharedAccessPolicyName"> The name of the share access policy. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        internal SynapseIotHubDataConnection(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, SynapseDataConnectionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier iotHubResourceId, string consumerGroup, string tableName, string mappingRuleName, SynapseIotHubDataFormat? dataFormat, IList<string> eventSystemProperties, string sharedAccessPolicyName, ResourceProvisioningState? provisioningState) : base(id, name, resourceType, systemData, location, kind, serializedAdditionalRawData)
        {
            IotHubResourceId = iotHubResourceId;
            ConsumerGroup = consumerGroup;
            TableName = tableName;
            MappingRuleName = mappingRuleName;
            DataFormat = dataFormat;
            EventSystemProperties = eventSystemProperties;
            SharedAccessPolicyName = sharedAccessPolicyName;
            ProvisioningState = provisioningState;
            Kind = kind;
        }

        /// <summary> The resource ID of the Iot hub to be used to create a data connection. </summary>
        public ResourceIdentifier IotHubResourceId { get; set; }
        /// <summary> The iot hub consumer group. </summary>
        public string ConsumerGroup { get; set; }
        /// <summary> The table where the data should be ingested. Optionally the table information can be added to each message. </summary>
        public string TableName { get; set; }
        /// <summary> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </summary>
        public string MappingRuleName { get; set; }
        /// <summary> The data format of the message. Optionally the data format can be added to each message. </summary>
        public SynapseIotHubDataFormat? DataFormat { get; set; }
        /// <summary> System properties of the iot hub. </summary>
        public IList<string> EventSystemProperties { get; }
        /// <summary> The name of the share access policy. </summary>
        public string SharedAccessPolicyName { get; set; }
        /// <summary> The provisioned state of the resource. </summary>
        public ResourceProvisioningState? ProvisioningState { get; }
    }
}
