// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The state of integration runtime. </summary>
    public readonly partial struct SynapseIntegrationRuntimeState : IEquatable<SynapseIntegrationRuntimeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseIntegrationRuntimeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseIntegrationRuntimeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InitialValue = "Initial";
        private const string StoppedValue = "Stopped";
        private const string StartedValue = "Started";
        private const string StartingValue = "Starting";
        private const string StoppingValue = "Stopping";
        private const string NeedRegistrationValue = "NeedRegistration";
        private const string OnlineValue = "Online";
        private const string LimitedValue = "Limited";
        private const string OfflineValue = "Offline";
        private const string AccessDeniedValue = "AccessDenied";

        /// <summary> Initial. </summary>
        public static SynapseIntegrationRuntimeState Initial { get; } = new SynapseIntegrationRuntimeState(InitialValue);
        /// <summary> Stopped. </summary>
        public static SynapseIntegrationRuntimeState Stopped { get; } = new SynapseIntegrationRuntimeState(StoppedValue);
        /// <summary> Started. </summary>
        public static SynapseIntegrationRuntimeState Started { get; } = new SynapseIntegrationRuntimeState(StartedValue);
        /// <summary> Starting. </summary>
        public static SynapseIntegrationRuntimeState Starting { get; } = new SynapseIntegrationRuntimeState(StartingValue);
        /// <summary> Stopping. </summary>
        public static SynapseIntegrationRuntimeState Stopping { get; } = new SynapseIntegrationRuntimeState(StoppingValue);
        /// <summary> NeedRegistration. </summary>
        public static SynapseIntegrationRuntimeState NeedRegistration { get; } = new SynapseIntegrationRuntimeState(NeedRegistrationValue);
        /// <summary> Online. </summary>
        public static SynapseIntegrationRuntimeState Online { get; } = new SynapseIntegrationRuntimeState(OnlineValue);
        /// <summary> Limited. </summary>
        public static SynapseIntegrationRuntimeState Limited { get; } = new SynapseIntegrationRuntimeState(LimitedValue);
        /// <summary> Offline. </summary>
        public static SynapseIntegrationRuntimeState Offline { get; } = new SynapseIntegrationRuntimeState(OfflineValue);
        /// <summary> AccessDenied. </summary>
        public static SynapseIntegrationRuntimeState AccessDenied { get; } = new SynapseIntegrationRuntimeState(AccessDeniedValue);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeState"/> values are the same. </summary>
        public static bool operator ==(SynapseIntegrationRuntimeState left, SynapseIntegrationRuntimeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeState"/> values are not the same. </summary>
        public static bool operator !=(SynapseIntegrationRuntimeState left, SynapseIntegrationRuntimeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseIntegrationRuntimeState"/>. </summary>
        public static implicit operator SynapseIntegrationRuntimeState(string value) => new SynapseIntegrationRuntimeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseIntegrationRuntimeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseIntegrationRuntimeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
