// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/. </summary>
    public readonly partial struct SynapseIntegrationRuntimeSsisCatalogPricingTier : IEquatable<SynapseIntegrationRuntimeSsisCatalogPricingTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseIntegrationRuntimeSsisCatalogPricingTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseIntegrationRuntimeSsisCatalogPricingTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";
        private const string PremiumRSValue = "PremiumRS";

        /// <summary> Basic. </summary>
        public static SynapseIntegrationRuntimeSsisCatalogPricingTier Basic { get; } = new SynapseIntegrationRuntimeSsisCatalogPricingTier(BasicValue);
        /// <summary> Standard. </summary>
        public static SynapseIntegrationRuntimeSsisCatalogPricingTier Standard { get; } = new SynapseIntegrationRuntimeSsisCatalogPricingTier(StandardValue);
        /// <summary> Premium. </summary>
        public static SynapseIntegrationRuntimeSsisCatalogPricingTier Premium { get; } = new SynapseIntegrationRuntimeSsisCatalogPricingTier(PremiumValue);
        /// <summary> PremiumRS. </summary>
        public static SynapseIntegrationRuntimeSsisCatalogPricingTier PremiumRS { get; } = new SynapseIntegrationRuntimeSsisCatalogPricingTier(PremiumRSValue);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeSsisCatalogPricingTier"/> values are the same. </summary>
        public static bool operator ==(SynapseIntegrationRuntimeSsisCatalogPricingTier left, SynapseIntegrationRuntimeSsisCatalogPricingTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeSsisCatalogPricingTier"/> values are not the same. </summary>
        public static bool operator !=(SynapseIntegrationRuntimeSsisCatalogPricingTier left, SynapseIntegrationRuntimeSsisCatalogPricingTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseIntegrationRuntimeSsisCatalogPricingTier"/>. </summary>
        public static implicit operator SynapseIntegrationRuntimeSsisCatalogPricingTier(string value) => new SynapseIntegrationRuntimeSsisCatalogPricingTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseIntegrationRuntimeSsisCatalogPricingTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseIntegrationRuntimeSsisCatalogPricingTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
