// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Get monitoring data response. </summary>
    public partial class SynapseIntegrationRuntimeMonitoringResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SynapseIntegrationRuntimeMonitoringResult"/>. </summary>
        internal SynapseIntegrationRuntimeMonitoringResult()
        {
            Nodes = new ChangeTrackingList<SynapseIntegrationRuntimeNodeMonitoringResult>();
        }

        /// <summary> Initializes a new instance of <see cref="SynapseIntegrationRuntimeMonitoringResult"/>. </summary>
        /// <param name="name"> Integration runtime name. </param>
        /// <param name="nodes"> Integration runtime node monitoring data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SynapseIntegrationRuntimeMonitoringResult(string name, IReadOnlyList<SynapseIntegrationRuntimeNodeMonitoringResult> nodes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Nodes = nodes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Integration runtime name. </summary>
        public string Name { get; }
        /// <summary> Integration runtime node monitoring data. </summary>
        public IReadOnlyList<SynapseIntegrationRuntimeNodeMonitoringResult> Nodes { get; }
    }
}
