// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> License type for bringing your own license scenario. </summary>
    public readonly partial struct SynapseIntegrationRuntimeLicenseType : IEquatable<SynapseIntegrationRuntimeLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseIntegrationRuntimeLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseIntegrationRuntimeLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasePriceValue = "BasePrice";
        private const string LicenseIncludedValue = "LicenseIncluded";

        /// <summary> BasePrice. </summary>
        public static SynapseIntegrationRuntimeLicenseType BasePrice { get; } = new SynapseIntegrationRuntimeLicenseType(BasePriceValue);
        /// <summary> LicenseIncluded. </summary>
        public static SynapseIntegrationRuntimeLicenseType LicenseIncluded { get; } = new SynapseIntegrationRuntimeLicenseType(LicenseIncludedValue);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeLicenseType"/> values are the same. </summary>
        public static bool operator ==(SynapseIntegrationRuntimeLicenseType left, SynapseIntegrationRuntimeLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeLicenseType"/> values are not the same. </summary>
        public static bool operator !=(SynapseIntegrationRuntimeLicenseType left, SynapseIntegrationRuntimeLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseIntegrationRuntimeLicenseType"/>. </summary>
        public static implicit operator SynapseIntegrationRuntimeLicenseType(string value) => new SynapseIntegrationRuntimeLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseIntegrationRuntimeLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseIntegrationRuntimeLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
