// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration runtime nodes exist). </summary>
    public readonly partial struct SynapseIntegrationRuntimeInternalChannelEncryptionMode : IEquatable<SynapseIntegrationRuntimeInternalChannelEncryptionMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseIntegrationRuntimeInternalChannelEncryptionMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseIntegrationRuntimeInternalChannelEncryptionMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSetValue = "NotSet";
        private const string SslEncryptedValue = "SslEncrypted";
        private const string NotEncryptedValue = "NotEncrypted";

        /// <summary> NotSet. </summary>
        public static SynapseIntegrationRuntimeInternalChannelEncryptionMode NotSet { get; } = new SynapseIntegrationRuntimeInternalChannelEncryptionMode(NotSetValue);
        /// <summary> SslEncrypted. </summary>
        public static SynapseIntegrationRuntimeInternalChannelEncryptionMode SslEncrypted { get; } = new SynapseIntegrationRuntimeInternalChannelEncryptionMode(SslEncryptedValue);
        /// <summary> NotEncrypted. </summary>
        public static SynapseIntegrationRuntimeInternalChannelEncryptionMode NotEncrypted { get; } = new SynapseIntegrationRuntimeInternalChannelEncryptionMode(NotEncryptedValue);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeInternalChannelEncryptionMode"/> values are the same. </summary>
        public static bool operator ==(SynapseIntegrationRuntimeInternalChannelEncryptionMode left, SynapseIntegrationRuntimeInternalChannelEncryptionMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeInternalChannelEncryptionMode"/> values are not the same. </summary>
        public static bool operator !=(SynapseIntegrationRuntimeInternalChannelEncryptionMode left, SynapseIntegrationRuntimeInternalChannelEncryptionMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseIntegrationRuntimeInternalChannelEncryptionMode"/>. </summary>
        public static implicit operator SynapseIntegrationRuntimeInternalChannelEncryptionMode(string value) => new SynapseIntegrationRuntimeInternalChannelEncryptionMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseIntegrationRuntimeInternalChannelEncryptionMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseIntegrationRuntimeInternalChannelEncryptionMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
