// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The edition for the SSIS Integration Runtime. </summary>
    public readonly partial struct SynapseIntegrationRuntimeEdition : IEquatable<SynapseIntegrationRuntimeEdition>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseIntegrationRuntimeEdition"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseIntegrationRuntimeEdition(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string EnterpriseValue = "Enterprise";

        /// <summary> Standard. </summary>
        public static SynapseIntegrationRuntimeEdition Standard { get; } = new SynapseIntegrationRuntimeEdition(StandardValue);
        /// <summary> Enterprise. </summary>
        public static SynapseIntegrationRuntimeEdition Enterprise { get; } = new SynapseIntegrationRuntimeEdition(EnterpriseValue);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeEdition"/> values are the same. </summary>
        public static bool operator ==(SynapseIntegrationRuntimeEdition left, SynapseIntegrationRuntimeEdition right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseIntegrationRuntimeEdition"/> values are not the same. </summary>
        public static bool operator !=(SynapseIntegrationRuntimeEdition left, SynapseIntegrationRuntimeEdition right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseIntegrationRuntimeEdition"/>. </summary>
        public static implicit operator SynapseIntegrationRuntimeEdition(string value) => new SynapseIntegrationRuntimeEdition(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseIntegrationRuntimeEdition other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseIntegrationRuntimeEdition other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
