// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Synapse.Models
{
    public partial class SynapseFollowerDatabaseDefinition : IUtf8JsonSerializable, IJsonModel<SynapseFollowerDatabaseDefinition>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SynapseFollowerDatabaseDefinition>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SynapseFollowerDatabaseDefinition>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseFollowerDatabaseDefinition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseFollowerDatabaseDefinition)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("clusterResourceId"u8);
            writer.WriteStringValue(KustoPoolResourceId);
            writer.WritePropertyName("attachedDatabaseConfigurationName"u8);
            writer.WriteStringValue(AttachedDatabaseConfigurationName);
            if (options.Format != "W" && Optional.IsDefined(DatabaseName))
            {
                writer.WritePropertyName("databaseName"u8);
                writer.WriteStringValue(DatabaseName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SynapseFollowerDatabaseDefinition IJsonModel<SynapseFollowerDatabaseDefinition>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseFollowerDatabaseDefinition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseFollowerDatabaseDefinition)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSynapseFollowerDatabaseDefinition(document.RootElement, options);
        }

        internal static SynapseFollowerDatabaseDefinition DeserializeSynapseFollowerDatabaseDefinition(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier clusterResourceId = default;
            string attachedDatabaseConfigurationName = default;
            string databaseName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clusterResourceId"u8))
                {
                    clusterResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("attachedDatabaseConfigurationName"u8))
                {
                    attachedDatabaseConfigurationName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("databaseName"u8))
                {
                    databaseName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SynapseFollowerDatabaseDefinition(clusterResourceId, attachedDatabaseConfigurationName, databaseName, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SynapseFollowerDatabaseDefinition>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseFollowerDatabaseDefinition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SynapseFollowerDatabaseDefinition)} does not support writing '{options.Format}' format.");
            }
        }

        SynapseFollowerDatabaseDefinition IPersistableModel<SynapseFollowerDatabaseDefinition>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseFollowerDatabaseDefinition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSynapseFollowerDatabaseDefinition(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SynapseFollowerDatabaseDefinition)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SynapseFollowerDatabaseDefinition>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
