// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The data format of the message. Optionally the data format can be added to each message. </summary>
    public readonly partial struct SynapseEventHubDataFormat : IEquatable<SynapseEventHubDataFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseEventHubDataFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseEventHubDataFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MultiJsonValue = "MULTIJSON";
        private const string JsonValue = "JSON";
        private const string CsvValue = "CSV";
        private const string TsvValue = "TSV";
        private const string ScsvValue = "SCSV";
        private const string SohsvValue = "SOHSV";
        private const string PsvValue = "PSV";
        private const string TxtValue = "TXT";
        private const string RawValue = "RAW";
        private const string SingleJsonValue = "SINGLEJSON";
        private const string AvroValue = "AVRO";
        private const string TsveValue = "TSVE";
        private const string ParquetValue = "PARQUET";
        private const string OrcValue = "ORC";
        private const string ApacheAvroValue = "APACHEAVRO";
        private const string W3CLogfileValue = "W3CLOGFILE";

        /// <summary> MULTIJSON. </summary>
        public static SynapseEventHubDataFormat MultiJson { get; } = new SynapseEventHubDataFormat(MultiJsonValue);
        /// <summary> JSON. </summary>
        public static SynapseEventHubDataFormat Json { get; } = new SynapseEventHubDataFormat(JsonValue);
        /// <summary> CSV. </summary>
        public static SynapseEventHubDataFormat Csv { get; } = new SynapseEventHubDataFormat(CsvValue);
        /// <summary> TSV. </summary>
        public static SynapseEventHubDataFormat Tsv { get; } = new SynapseEventHubDataFormat(TsvValue);
        /// <summary> SCSV. </summary>
        public static SynapseEventHubDataFormat Scsv { get; } = new SynapseEventHubDataFormat(ScsvValue);
        /// <summary> SOHSV. </summary>
        public static SynapseEventHubDataFormat Sohsv { get; } = new SynapseEventHubDataFormat(SohsvValue);
        /// <summary> PSV. </summary>
        public static SynapseEventHubDataFormat Psv { get; } = new SynapseEventHubDataFormat(PsvValue);
        /// <summary> TXT. </summary>
        public static SynapseEventHubDataFormat Txt { get; } = new SynapseEventHubDataFormat(TxtValue);
        /// <summary> RAW. </summary>
        public static SynapseEventHubDataFormat Raw { get; } = new SynapseEventHubDataFormat(RawValue);
        /// <summary> SINGLEJSON. </summary>
        public static SynapseEventHubDataFormat SingleJson { get; } = new SynapseEventHubDataFormat(SingleJsonValue);
        /// <summary> AVRO. </summary>
        public static SynapseEventHubDataFormat Avro { get; } = new SynapseEventHubDataFormat(AvroValue);
        /// <summary> TSVE. </summary>
        public static SynapseEventHubDataFormat Tsve { get; } = new SynapseEventHubDataFormat(TsveValue);
        /// <summary> PARQUET. </summary>
        public static SynapseEventHubDataFormat Parquet { get; } = new SynapseEventHubDataFormat(ParquetValue);
        /// <summary> ORC. </summary>
        public static SynapseEventHubDataFormat Orc { get; } = new SynapseEventHubDataFormat(OrcValue);
        /// <summary> APACHEAVRO. </summary>
        public static SynapseEventHubDataFormat ApacheAvro { get; } = new SynapseEventHubDataFormat(ApacheAvroValue);
        /// <summary> W3CLOGFILE. </summary>
        public static SynapseEventHubDataFormat W3CLogfile { get; } = new SynapseEventHubDataFormat(W3CLogfileValue);
        /// <summary> Determines if two <see cref="SynapseEventHubDataFormat"/> values are the same. </summary>
        public static bool operator ==(SynapseEventHubDataFormat left, SynapseEventHubDataFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseEventHubDataFormat"/> values are not the same. </summary>
        public static bool operator !=(SynapseEventHubDataFormat left, SynapseEventHubDataFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseEventHubDataFormat"/>. </summary>
        public static implicit operator SynapseEventHubDataFormat(string value) => new SynapseEventHubDataFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseEventHubDataFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseEventHubDataFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
