// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The data format of the message. Optionally the data format can be added to each message. </summary>
    public readonly partial struct SynapseEventGridDataFormat : IEquatable<SynapseEventGridDataFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseEventGridDataFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseEventGridDataFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MultiJsonValue = "MULTIJSON";
        private const string JsonValue = "JSON";
        private const string CsvValue = "CSV";
        private const string TsvValue = "TSV";
        private const string ScsvValue = "SCSV";
        private const string SohsvValue = "SOHSV";
        private const string PsvValue = "PSV";
        private const string TxtValue = "TXT";
        private const string RawValue = "RAW";
        private const string SingleJsonValue = "SINGLEJSON";
        private const string AvroValue = "AVRO";
        private const string TsveValue = "TSVE";
        private const string ParquetValue = "PARQUET";
        private const string OrcValue = "ORC";
        private const string ApacheAvroValue = "APACHEAVRO";
        private const string W3CLogfileValue = "W3CLOGFILE";

        /// <summary> MULTIJSON. </summary>
        public static SynapseEventGridDataFormat MultiJson { get; } = new SynapseEventGridDataFormat(MultiJsonValue);
        /// <summary> JSON. </summary>
        public static SynapseEventGridDataFormat Json { get; } = new SynapseEventGridDataFormat(JsonValue);
        /// <summary> CSV. </summary>
        public static SynapseEventGridDataFormat Csv { get; } = new SynapseEventGridDataFormat(CsvValue);
        /// <summary> TSV. </summary>
        public static SynapseEventGridDataFormat Tsv { get; } = new SynapseEventGridDataFormat(TsvValue);
        /// <summary> SCSV. </summary>
        public static SynapseEventGridDataFormat Scsv { get; } = new SynapseEventGridDataFormat(ScsvValue);
        /// <summary> SOHSV. </summary>
        public static SynapseEventGridDataFormat Sohsv { get; } = new SynapseEventGridDataFormat(SohsvValue);
        /// <summary> PSV. </summary>
        public static SynapseEventGridDataFormat Psv { get; } = new SynapseEventGridDataFormat(PsvValue);
        /// <summary> TXT. </summary>
        public static SynapseEventGridDataFormat Txt { get; } = new SynapseEventGridDataFormat(TxtValue);
        /// <summary> RAW. </summary>
        public static SynapseEventGridDataFormat Raw { get; } = new SynapseEventGridDataFormat(RawValue);
        /// <summary> SINGLEJSON. </summary>
        public static SynapseEventGridDataFormat SingleJson { get; } = new SynapseEventGridDataFormat(SingleJsonValue);
        /// <summary> AVRO. </summary>
        public static SynapseEventGridDataFormat Avro { get; } = new SynapseEventGridDataFormat(AvroValue);
        /// <summary> TSVE. </summary>
        public static SynapseEventGridDataFormat Tsve { get; } = new SynapseEventGridDataFormat(TsveValue);
        /// <summary> PARQUET. </summary>
        public static SynapseEventGridDataFormat Parquet { get; } = new SynapseEventGridDataFormat(ParquetValue);
        /// <summary> ORC. </summary>
        public static SynapseEventGridDataFormat Orc { get; } = new SynapseEventGridDataFormat(OrcValue);
        /// <summary> APACHEAVRO. </summary>
        public static SynapseEventGridDataFormat ApacheAvro { get; } = new SynapseEventGridDataFormat(ApacheAvroValue);
        /// <summary> W3CLOGFILE. </summary>
        public static SynapseEventGridDataFormat W3CLogfile { get; } = new SynapseEventGridDataFormat(W3CLogfileValue);
        /// <summary> Determines if two <see cref="SynapseEventGridDataFormat"/> values are the same. </summary>
        public static bool operator ==(SynapseEventGridDataFormat left, SynapseEventGridDataFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseEventGridDataFormat"/> values are not the same. </summary>
        public static bool operator !=(SynapseEventGridDataFormat left, SynapseEventGridDataFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseEventGridDataFormat"/>. </summary>
        public static implicit operator SynapseEventGridDataFormat(string value) => new SynapseEventGridDataFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseEventGridDataFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseEventGridDataFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
