// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Synapse.Models
{
    public partial class SynapseEncryptionDetails : IUtf8JsonSerializable, IJsonModel<SynapseEncryptionDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SynapseEncryptionDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SynapseEncryptionDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseEncryptionDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(IsDoubleEncryptionEnabled))
            {
                writer.WritePropertyName("doubleEncryptionEnabled"u8);
                writer.WriteBooleanValue(IsDoubleEncryptionEnabled.Value);
            }
            if (Optional.IsDefined(Cmk))
            {
                writer.WritePropertyName("cmk"u8);
                writer.WriteObjectValue(Cmk, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SynapseEncryptionDetails IJsonModel<SynapseEncryptionDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SynapseEncryptionDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSynapseEncryptionDetails(document.RootElement, options);
        }

        internal static SynapseEncryptionDetails DeserializeSynapseEncryptionDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? doubleEncryptionEnabled = default;
            WorkspaceCustomerManagedKeyDetails cmk = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("doubleEncryptionEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    doubleEncryptionEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("cmk"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cmk = WorkspaceCustomerManagedKeyDetails.DeserializeWorkspaceCustomerManagedKeyDetails(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SynapseEncryptionDetails(doubleEncryptionEnabled, cmk, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SynapseEncryptionDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SynapseEncryptionDetails)} does not support writing '{options.Format}' format.");
            }
        }

        SynapseEncryptionDetails IPersistableModel<SynapseEncryptionDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SynapseEncryptionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSynapseEncryptionDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SynapseEncryptionDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SynapseEncryptionDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
