// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Synapse.Models
{
    internal static partial class SynapseDesiredStateExtensions
    {
        public static string ToSerialString(this SynapseDesiredState value) => value switch
        {
            SynapseDesiredState.Enabled => "Enabled",
            SynapseDesiredState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SynapseDesiredState value.")
        };

        public static SynapseDesiredState ToSynapseDesiredState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return SynapseDesiredState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return SynapseDesiredState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SynapseDesiredState value.");
        }
    }
}
