// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The default principals modification kind. </summary>
    public readonly partial struct SynapseDefaultPrincipalsModificationKind : IEquatable<SynapseDefaultPrincipalsModificationKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseDefaultPrincipalsModificationKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseDefaultPrincipalsModificationKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnionValue = "Union";
        private const string ReplaceValue = "Replace";
        private const string NoneValue = "None";

        /// <summary> Union. </summary>
        public static SynapseDefaultPrincipalsModificationKind Union { get; } = new SynapseDefaultPrincipalsModificationKind(UnionValue);
        /// <summary> Replace. </summary>
        public static SynapseDefaultPrincipalsModificationKind Replace { get; } = new SynapseDefaultPrincipalsModificationKind(ReplaceValue);
        /// <summary> None. </summary>
        public static SynapseDefaultPrincipalsModificationKind None { get; } = new SynapseDefaultPrincipalsModificationKind(NoneValue);
        /// <summary> Determines if two <see cref="SynapseDefaultPrincipalsModificationKind"/> values are the same. </summary>
        public static bool operator ==(SynapseDefaultPrincipalsModificationKind left, SynapseDefaultPrincipalsModificationKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseDefaultPrincipalsModificationKind"/> values are not the same. </summary>
        public static bool operator !=(SynapseDefaultPrincipalsModificationKind left, SynapseDefaultPrincipalsModificationKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseDefaultPrincipalsModificationKind"/>. </summary>
        public static implicit operator SynapseDefaultPrincipalsModificationKind(string value) => new SynapseDefaultPrincipalsModificationKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseDefaultPrincipalsModificationKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseDefaultPrincipalsModificationKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
