// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Database principal role. </summary>
    public readonly partial struct SynapseDatabasePrincipalRole : IEquatable<SynapseDatabasePrincipalRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseDatabasePrincipalRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseDatabasePrincipalRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AdminValue = "Admin";
        private const string IngestorValue = "Ingestor";
        private const string MonitorValue = "Monitor";
        private const string UserValue = "User";
        private const string UnrestrictedViewerValue = "UnrestrictedViewer";
        private const string ViewerValue = "Viewer";

        /// <summary> Admin. </summary>
        public static SynapseDatabasePrincipalRole Admin { get; } = new SynapseDatabasePrincipalRole(AdminValue);
        /// <summary> Ingestor. </summary>
        public static SynapseDatabasePrincipalRole Ingestor { get; } = new SynapseDatabasePrincipalRole(IngestorValue);
        /// <summary> Monitor. </summary>
        public static SynapseDatabasePrincipalRole Monitor { get; } = new SynapseDatabasePrincipalRole(MonitorValue);
        /// <summary> User. </summary>
        public static SynapseDatabasePrincipalRole User { get; } = new SynapseDatabasePrincipalRole(UserValue);
        /// <summary> UnrestrictedViewer. </summary>
        public static SynapseDatabasePrincipalRole UnrestrictedViewer { get; } = new SynapseDatabasePrincipalRole(UnrestrictedViewerValue);
        /// <summary> Viewer. </summary>
        public static SynapseDatabasePrincipalRole Viewer { get; } = new SynapseDatabasePrincipalRole(ViewerValue);
        /// <summary> Determines if two <see cref="SynapseDatabasePrincipalRole"/> values are the same. </summary>
        public static bool operator ==(SynapseDatabasePrincipalRole left, SynapseDatabasePrincipalRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseDatabasePrincipalRole"/> values are not the same. </summary>
        public static bool operator !=(SynapseDatabasePrincipalRole left, SynapseDatabasePrincipalRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseDatabasePrincipalRole"/>. </summary>
        public static implicit operator SynapseDatabasePrincipalRole(string value) => new SynapseDatabasePrincipalRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseDatabasePrincipalRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseDatabasePrincipalRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
