// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> The SynapseDataWarehouseUserActivityName. </summary>
    public readonly partial struct SynapseDataWarehouseUserActivityName : IEquatable<SynapseDataWarehouseUserActivityName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseDataWarehouseUserActivityName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseDataWarehouseUserActivityName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CurrentValue = "current";

        /// <summary> current. </summary>
        public static SynapseDataWarehouseUserActivityName Current { get; } = new SynapseDataWarehouseUserActivityName(CurrentValue);
        /// <summary> Determines if two <see cref="SynapseDataWarehouseUserActivityName"/> values are the same. </summary>
        public static bool operator ==(SynapseDataWarehouseUserActivityName left, SynapseDataWarehouseUserActivityName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseDataWarehouseUserActivityName"/> values are not the same. </summary>
        public static bool operator !=(SynapseDataWarehouseUserActivityName left, SynapseDataWarehouseUserActivityName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseDataWarehouseUserActivityName"/>. </summary>
        public static implicit operator SynapseDataWarehouseUserActivityName(string value) => new SynapseDataWarehouseUserActivityName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseDataWarehouseUserActivityName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseDataWarehouseUserActivityName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
