// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Synapse.Models
{
    /// <summary> Scale type. </summary>
    public readonly partial struct SynapseDataSourceScaleType : IEquatable<SynapseDataSourceScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynapseDataSourceScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynapseDataSourceScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "automatic";
        private const string ManualValue = "manual";
        private const string NoneValue = "none";

        /// <summary> automatic. </summary>
        public static SynapseDataSourceScaleType Automatic { get; } = new SynapseDataSourceScaleType(AutomaticValue);
        /// <summary> manual. </summary>
        public static SynapseDataSourceScaleType Manual { get; } = new SynapseDataSourceScaleType(ManualValue);
        /// <summary> none. </summary>
        public static SynapseDataSourceScaleType None { get; } = new SynapseDataSourceScaleType(NoneValue);
        /// <summary> Determines if two <see cref="SynapseDataSourceScaleType"/> values are the same. </summary>
        public static bool operator ==(SynapseDataSourceScaleType left, SynapseDataSourceScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynapseDataSourceScaleType"/> values are not the same. </summary>
        public static bool operator !=(SynapseDataSourceScaleType left, SynapseDataSourceScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynapseDataSourceScaleType"/>. </summary>
        public static implicit operator SynapseDataSourceScaleType(string value) => new SynapseDataSourceScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynapseDataSourceScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynapseDataSourceScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
